/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs;

import de.oliver.fancynpcs.api.AttributeManager;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_19_4.attributes.Attributes_1_19_4;
import de.oliver.fancynpcs.v1_20_1.attributes.Attributes_1_20_1;
import de.oliver.fancynpcs.v1_20_2.attributes.Attributes_1_20_2;
import de.oliver.fancynpcs.v1_20_4.attributes.Attributes_1_20_4;
import de.oliver.fancynpcs.v1_20_6.attributes.Attributes_1_20_5;
import de.oliver.fancynpcs.v1_21_1.attributes.Attributes_1_21_1;
import de.oliver.fancynpcs.v1_21_3.attributes.Attributes_1_21_3;
import de.oliver.fancynpcs.v1_21_4.attributes.Attributes_1_21_4;
import de.oliver.fancynpcs.v1_21_5.attributes.Attributes_1_21_5;
import de.oliver.fancynpcs.v1_21_6.attributes.Attributes_1_21_6;
import de.oliver.fancynpcs.v1_21_9.attributes.Attributes_1_21_9;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;

public class AttributeManagerImpl
implements AttributeManager {
    private List<NpcAttribute> attributes = new ArrayList<NpcAttribute>();

    public AttributeManagerImpl() {
        this.init();
    }

    private void init() {
        String mcVersion;
        switch (mcVersion = Bukkit.getMinecraftVersion()) {
            case "1.21.9": 
            case "1.21.10": {
                this.attributes = Attributes_1_21_9.getAllAttributes();
                break;
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                this.attributes = Attributes_1_21_6.getAllAttributes();
                break;
            }
            case "1.21.5": {
                this.attributes = Attributes_1_21_5.getAllAttributes();
                break;
            }
            case "1.21.4": {
                this.attributes = Attributes_1_21_4.getAllAttributes();
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                this.attributes = Attributes_1_21_3.getAllAttributes();
                break;
            }
            case "1.21": 
            case "1.21.1": {
                this.attributes = Attributes_1_21_1.getAllAttributes();
                break;
            }
            case "1.20.5": 
            case "1.20.6": {
                this.attributes = Attributes_1_20_5.getAllAttributes();
                break;
            }
            case "1.20.3": 
            case "1.20.4": {
                this.attributes = Attributes_1_20_4.getAllAttributes();
                break;
            }
            case "1.20.2": {
                this.attributes = Attributes_1_20_2.getAllAttributes();
                break;
            }
            case "1.20.1": 
            case "1.20": {
                this.attributes = Attributes_1_20_1.getAllAttributes();
                break;
            }
            case "1.19.4": {
                this.attributes = Attributes_1_19_4.getAllAttributes();
            }
        }
    }

    @Override
    public NpcAttribute getAttributeByName(EntityType type, String name) {
        for (NpcAttribute attribute : this.attributes) {
            if (!attribute.getTypes().contains(type) || !attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void registerAttribute(NpcAttribute attribute) {
        this.attributes.add(attribute);
    }

    @Override
    public List<NpcAttribute> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public List<NpcAttribute> getAllAttributesForEntityType(EntityType type) {
        return this.attributes.stream().filter(attribute -> attribute.getTypes().contains(type)).toList();
    }
}

