/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_19_4.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_19_4.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.item.EnumColor;
import org.bukkit.entity.EntityType;

public class ShulkerAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("color", Arrays.stream(EnumColor.values()).map(Enum::name).toList(), List.of(EntityType.SHULKER), ShulkerAttributes::setColor));
        attributes.add(new NpcAttribute("shield", List.of("open", "closed"), List.of(EntityType.SHULKER), ShulkerAttributes::setShield));
        return attributes;
    }

    private static void setColor(Npc npc, String value) {
        EntityShulker shulker = (EntityShulker)ReflectionHelper.getEntity(npc);
        EnumColor color = EnumColor.a((String)value.toLowerCase(), (EnumColor)EnumColor.k);
        shulker.a(Optional.of(color));
    }

    private static void setShield(Npc npc, String value) {
        EntityShulker shulker = (EntityShulker)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "closed": {
                shulker.b(0);
                break;
            }
            case "open": {
                shulker.b(127);
            }
        }
    }
}

