/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_4;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import de.oliver.fancylib.ReflectionUtils;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.events.NpcSpawnEvent;
import de.oliver.fancynpcs.api.utils.NpcEquipmentSlot;
import de.oliver.fancynpcs.libs.chatcolorhandler.ModernChatColorHandler;
import de.oliver.fancynpcs.v1_20_4.MappingKeys1_20_4;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.Optionull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Npc_1_20_4
extends Npc {
    private final String localName = this.generateLocalName();
    private final UUID uuid = UUID.randomUUID();
    private Entity npc;
    private Display.TextDisplay sittingVehicle;

    public Npc_1_20_4(NpcData data) {
        super(data);
    }

    @Override
    public void create() {
        DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer serverLevel = ((CraftWorld)this.data.getLocation().getWorld()).getHandle();
        GameProfile gameProfile = new GameProfile(this.uuid, this.localName);
        if (this.data.getType() == EntityType.PLAYER) {
            this.npc = new EntityPlayer((MinecraftServer)minecraftServer, serverLevel, new GameProfile(this.uuid, ""), ClientInformation.a());
            ((EntityPlayer)this.npc).cq = gameProfile;
        } else {
            EntityTypes nmsType = (EntityTypes)BuiltInRegistries.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)this.data.getType().getKey()));
            EntityTypes.b factory = (EntityTypes.b)ReflectionUtils.getValue(nmsType, MappingKeys1_20_4.ENTITY_TYPE__FACTORY.getMapping());
            this.npc = factory.create(nmsType, (World)serverLevel);
            this.isTeamCreated.clear();
        }
    }

    @Override
    public void spawn(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (this.npc == null) {
            return;
        }
        if (!this.data.getLocation().getWorld().getName().equalsIgnoreCase(serverPlayer.dM().getWorld().getName())) {
            return;
        }
        if (this.data.getSkinData() != null && this.data.getSkinData().hasTexture()) {
            String value = this.data.getSkinData().getTextureValue();
            String signature = this.data.getSkinData().getTextureSignature();
            ((EntityPlayer)this.npc).fR().getProperties().replaceValues((Object)"textures", ImmutableList.of(new Property("textures", value, signature)));
        }
        NpcSpawnEvent spawnEvent = new NpcSpawnEvent(this, player);
        spawnEvent.callEvent();
        if (spawnEvent.isCancelled()) {
            return;
        }
        Entity entity = this.npc;
        if (entity instanceof EntityPlayer) {
            EntityPlayer npcPlayer = (EntityPlayer)entity;
            EnumSet<ClientboundPlayerInfoUpdatePacket.a> actions = EnumSet.noneOf(ClientboundPlayerInfoUpdatePacket.a.class);
            actions.add(ClientboundPlayerInfoUpdatePacket.a.a);
            actions.add(ClientboundPlayerInfoUpdatePacket.a.f);
            if (this.data.isShowInTab()) {
                actions.add(ClientboundPlayerInfoUpdatePacket.a.d);
            }
            ClientboundPlayerInfoUpdatePacket playerInfoPacket = new ClientboundPlayerInfoUpdatePacket(actions, this.getEntry(npcPlayer, serverPlayer));
            serverPlayer.c.b((Packet)playerInfoPacket);
            if (this.data.isSpawnEntity()) {
                this.npc.a_(this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z());
            }
        }
        PacketPlayOutSpawnEntity addEntityPacket = new PacketPlayOutSpawnEntity(this.npc);
        serverPlayer.c.b((Packet)addEntityPacket);
        this.isVisibleForPlayer.put(player.getUniqueId(), true);
        int removeNpcsFromPlayerlistDelay = FancyNpcsPlugin.get().getFancyNpcConfig().getRemoveNpcsFromPlayerlistDelay();
        if (!this.data.isShowInTab() && removeNpcsFromPlayerlistDelay > 0) {
            FancyNpcsPlugin.get().getNpcThread().schedule(() -> {
                ClientboundPlayerInfoRemovePacket playerInfoRemovePacket = new ClientboundPlayerInfoRemovePacket(List.of(this.npc.cw()));
                serverPlayer.c.b((Packet)playerInfoRemovePacket);
            }, (long)removeNpcsFromPlayerlistDelay, TimeUnit.MILLISECONDS);
        }
        this.update(player);
    }

    @Override
    public void remove(Player player) {
        if (this.npc == null) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Entity entity = this.npc;
        if (entity instanceof EntityPlayer) {
            EntityPlayer npcPlayer = (EntityPlayer)entity;
            ClientboundPlayerInfoRemovePacket playerInfoRemovePacket = new ClientboundPlayerInfoRemovePacket(List.of(npcPlayer.cw()));
            serverPlayer.c.b((Packet)playerInfoRemovePacket);
        }
        PacketPlayOutEntityDestroy removeEntitiesPacket = new PacketPlayOutEntityDestroy(new int[]{this.npc.aj()});
        serverPlayer.c.b((Packet)removeEntitiesPacket);
        if (this.sittingVehicle != null) {
            PacketPlayOutEntityDestroy removeSittingVehiclePacket = new PacketPlayOutEntityDestroy(new int[]{this.sittingVehicle.aj()});
            serverPlayer.c.b((Packet)removeSittingVehiclePacket);
        }
        this.isVisibleForPlayer.put(serverPlayer.cw(), false);
    }

    @Override
    public void lookAt(Player player, Location location) {
        if (this.npc == null) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        this.npc.a(location.getYaw(), location.getPitch());
        this.npc.n(location.getYaw());
        this.npc.s(location.getPitch());
        this.npc.r(location.getYaw());
        PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport(this.npc);
        serverPlayer.c.b((Packet)teleportEntityPacket);
        float angelMultiplier = 0.7111111f;
        PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation(this.npc, (byte)(location.getYaw() * angelMultiplier));
        serverPlayer.c.b((Packet)rotateHeadPacket);
    }

    @Override
    public void update(Player player, boolean swingArm) {
        String string;
        if (this.npc == null) {
            return;
        }
        if (!this.isVisibleForPlayer.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ScoreboardTeam team = new ScoreboardTeam(new Scoreboard(), "npc-" + this.localName);
        team.g().clear();
        Collection collection = team.g();
        Entity entity = this.npc;
        if (entity instanceof EntityPlayer) {
            EntityPlayer npcPlayer = (EntityPlayer)entity;
            string = npcPlayer.fR().getName();
        } else {
            string = this.npc.cx();
        }
        collection.add(string);
        team.a(PaperAdventure.asVanilla((TextColor)this.data.getGlowingColor()));
        if (!this.data.isCollidable()) {
            team.a(ScoreboardTeamBase.EnumTeamPush.b);
        }
        Component displayName = ModernChatColorHandler.translate(this.data.getDisplayName(), (Player)serverPlayer.getBukkitEntity());
        IChatBaseComponent vanillaComponent = PaperAdventure.asVanilla((Component)displayName);
        if (!(this.npc instanceof EntityPlayer)) {
            this.npc.b(vanillaComponent);
            this.npc.n(true);
        } else {
            this.npc.b(null);
            this.npc.n(false);
        }
        if (this.data.getDisplayName().equalsIgnoreCase("<empty>")) {
            team.a(ScoreboardTeamBase.EnumNameTagVisibility.b);
            this.npc.b(null);
            this.npc.n(false);
        } else {
            team.a(ScoreboardTeamBase.EnumNameTagVisibility.a);
        }
        Entity entity2 = this.npc;
        if (entity2 instanceof EntityPlayer) {
            EntityPlayer npcPlayer = (EntityPlayer)entity2;
            team.b(vanillaComponent);
            npcPlayer.listName = vanillaComponent;
            EnumSet<ClientboundPlayerInfoUpdatePacket.a> actions = EnumSet.noneOf(ClientboundPlayerInfoUpdatePacket.a.class);
            actions.add(ClientboundPlayerInfoUpdatePacket.a.f);
            if (this.data.isShowInTab()) {
                actions.add(ClientboundPlayerInfoUpdatePacket.a.d);
            }
            ClientboundPlayerInfoUpdatePacket playerInfoPacket = new ClientboundPlayerInfoUpdatePacket(actions, this.getEntry(npcPlayer, serverPlayer));
            serverPlayer.c.b((Packet)playerInfoPacket);
        }
        boolean isTeamCreatedForPlayer = this.isTeamCreated.getOrDefault(player.getUniqueId(), false);
        serverPlayer.c.b((Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (!isTeamCreatedForPlayer ? 1 : 0) != 0));
        this.isTeamCreated.put(player.getUniqueId(), true);
        this.npc.i(this.data.isGlowing());
        if (this.data.getEquipment() != null && this.data.getEquipment().size() > 0) {
            ArrayList<Pair> equipmentList = new ArrayList<Pair>();
            for (NpcEquipmentSlot slot : this.data.getEquipment().keySet()) {
                equipmentList.add(new Pair((Object)EnumItemSlot.a((String)slot.toNmsName()), (Object)CraftItemStack.asNMSCopy((ItemStack)this.data.getEquipment().get((Object)slot))));
            }
            PacketPlayOutEntityEquipment setEquipmentPacket = new PacketPlayOutEntityEquipment(this.npc.aj(), equipmentList);
            serverPlayer.c.b((Packet)setEquipmentPacket);
        }
        if (this.npc instanceof EntityPlayer) {
            this.npc.an().b(EntityHuman.bM, (Object)127);
        }
        this.data.applyAllAttributes(this);
        this.refreshEntityData(player);
        if (this.data.isSpawnEntity() && this.data.getLocation() != null) {
            this.move(player, swingArm);
        }
        NpcAttribute playerPoseAttr = FancyNpcsPlugin.get().getAttributeManager().getAttributeByName(EntityType.PLAYER, "pose");
        if (this.data.getAttributes().containsKey(playerPoseAttr)) {
            String pose = this.data.getAttributes().get(playerPoseAttr);
            if (pose.equals("sitting")) {
                this.setSitting(serverPlayer);
            } else if (this.sittingVehicle != null) {
                PacketPlayOutEntityDestroy removeSittingVehiclePacket = new PacketPlayOutEntityDestroy(new int[]{this.sittingVehicle.aj()});
                serverPlayer.c.b((Packet)removeSittingVehiclePacket);
            }
        }
    }

    @Override
    protected void refreshEntityData(Player player) {
        if (!this.isVisibleForPlayer.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Int2ObjectMap itemsById = (Int2ObjectMap)ReflectionUtils.getValue(this.npc.an(), MappingKeys1_20_4.SYNCHED_ENTITY_DATA__ITEMS_BY_ID.getMapping());
        ArrayList<DataWatcher.b> entityData = new ArrayList<DataWatcher.b>();
        for (DataWatcher.Item dataItem : itemsById.values()) {
            entityData.add(dataItem.e());
        }
        PacketPlayOutEntityMetadata setEntityDataPacket = new PacketPlayOutEntityMetadata(this.npc.aj(), entityData);
        serverPlayer.c.b((Packet)setEntityDataPacket);
    }

    @Override
    public void move(Player player, boolean swingArm) {
        if (this.npc == null) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        this.npc.p(this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z());
        this.npc.a(this.data.getLocation().getYaw(), this.data.getLocation().getPitch());
        this.npc.n(this.data.getLocation().getYaw());
        this.npc.s(this.data.getLocation().getPitch());
        this.npc.r(this.data.getLocation().getYaw());
        PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport(this.npc);
        ReflectionUtils.setValue(teleportEntityPacket, MappingKeys1_20_4.CLIENTBOUND_TELEPORT_ENTITY_PACKET__X.getMapping(), this.data.getLocation().x());
        ReflectionUtils.setValue(teleportEntityPacket, MappingKeys1_20_4.CLIENTBOUND_TELEPORT_ENTITY_PACKET__Y.getMapping(), this.data.getLocation().y());
        ReflectionUtils.setValue(teleportEntityPacket, MappingKeys1_20_4.CLIENTBOUND_TELEPORT_ENTITY_PACKET__Z.getMapping(), this.data.getLocation().z());
        serverPlayer.c.b((Packet)teleportEntityPacket);
        float angelMultiplier = 0.7111111f;
        PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation(this.npc, (byte)(this.data.getLocation().getYaw() * angelMultiplier));
        serverPlayer.c.b((Packet)rotateHeadPacket);
        if (swingArm && this.npc instanceof EntityPlayer) {
            PacketPlayOutAnimation animatePacket = new PacketPlayOutAnimation(this.npc, 0);
            serverPlayer.c.b((Packet)animatePacket);
        }
    }

    private ClientboundPlayerInfoUpdatePacket.b getEntry(EntityPlayer npcPlayer, EntityPlayer viewer) {
        GameProfile profile = npcPlayer.fR();
        if (this.data.isMirrorSkin() && EntityHuman.c((String)viewer.fR().getName())) {
            GameProfile newProfile = new GameProfile(profile.getId(), profile.getName());
            newProfile.getProperties().putAll((Multimap)viewer.fR().getProperties());
            profile = newProfile;
        }
        return new ClientboundPlayerInfoUpdatePacket.b(npcPlayer.cw(), profile, this.data.isShowInTab(), 0, npcPlayer.e.b(), npcPlayer.N(), (RemoteChatSession.a)Optionull.a((Object)npcPlayer.ab(), RemoteChatSession::a));
    }

    public void setSitting(EntityPlayer serverPlayer) {
        if (this.npc == null) {
            return;
        }
        if (this.sittingVehicle == null) {
            this.sittingVehicle = new Display.TextDisplay(EntityTypes.aY, (World)((CraftWorld)this.data.getLocation().getWorld()).getHandle());
        }
        this.sittingVehicle.a_(this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z());
        PacketPlayOutSpawnEntity addEntityPacket = new PacketPlayOutSpawnEntity((Entity)this.sittingVehicle);
        serverPlayer.c.b((Packet)addEntityPacket);
        this.sittingVehicle.r = ImmutableList.of(this.npc);
        PacketPlayOutMount packet = new PacketPlayOutMount((Entity)this.sittingVehicle);
        serverPlayer.c.b((Packet)packet);
    }

    @Override
    public float getEyeHeight() {
        return this.npc.cI();
    }

    @Override
    public int getEntityId() {
        return this.npc.aj();
    }

    public Entity getNpc() {
        return this.npc;
    }
}

