/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyanalytics.api.metrics;

import de.oliver.fancyanalytics.api.FancyAnalyticsAPI;
import de.oliver.fancyanalytics.api.metrics.MetricSupplier;
import de.oliver.fancyanalytics.sdk.metrics.defaults.DefaultSystemMetrics;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DefaultPluginMetrics {
    public static double playerCount() {
        return Bukkit.getOnlinePlayers().size();
    }

    public static double pluginCount() {
        return Bukkit.getPluginManager().getPlugins().length;
    }

    public static String serverSoftware() {
        return Bukkit.getServer().getName();
    }

    public static String serverVersion() {
        return Bukkit.getMinecraftVersion();
    }

    public static String pluginVersion(Plugin plugin) {
        return plugin.getDescription().getVersion();
    }

    public static void register(FancyAnalyticsAPI analytics) {
        analytics.registerStringMetric(new MetricSupplier<String>("operating_system", DefaultSystemMetrics::operatingSystem));
        analytics.registerStringMetric(new MetricSupplier<String>("operating_system_version", DefaultSystemMetrics::operatingSystemVersion));
        analytics.registerStringMetric(new MetricSupplier<String>("operating_system_architecture", DefaultSystemMetrics::operatingSystemArchitecture));
        analytics.registerNumberMetric(new MetricSupplier<Double>("cpu_cores", DefaultSystemMetrics::cpuCoreCount));
        analytics.registerStringMetric(new MetricSupplier<String>("java_version", DefaultSystemMetrics::javaVersion));
        analytics.registerStringMetric(new MetricSupplier<String>("jvm_name", DefaultSystemMetrics::jvmName));
        analytics.registerNumberMetric(new MetricSupplier<Double>("max_ram_gb", DefaultSystemMetrics::maxMemoryGB));
        analytics.registerNumberMetric(new MetricSupplier<Double>("used_ram_gb", DefaultSystemMetrics::usedMemoryGB));
        analytics.registerNumberMetric(new MetricSupplier<Double>("used_ram_percent", DefaultSystemMetrics::usedMemoryPercentage));
        analytics.registerNumberMetric(new MetricSupplier<Double>("cpu_usage_percent", DefaultSystemMetrics::cpuUsage));
        analytics.registerNumberMetric(new MetricSupplier<Double>("free_disk_space_gb", DefaultSystemMetrics::freeDiskSpaceGB));
        analytics.registerNumberMetric(new MetricSupplier<Double>("used_disk_space_gb", DefaultSystemMetrics::usedDiskSpaceGB));
        analytics.registerNumberMetric(new MetricSupplier<Double>("used_disk_space_percent", DefaultSystemMetrics::usedDiskSpacePercentage));
        analytics.registerNumberMetric(new MetricSupplier<Double>("network_in_kb", () -> -1.0));
        analytics.registerNumberMetric(new MetricSupplier<Double>("network_out_kb", () -> -1.0));
        analytics.registerNumberMetric(new MetricSupplier<Double>("uptime_seconds", DefaultSystemMetrics::uptimeSeconds));
        if (DefaultPluginMetrics.isBukkit()) {
            analytics.registerNumberMetric(new MetricSupplier<Double>("player_client_version", () -> -1.0));
            analytics.registerNumberMetric(new MetricSupplier<Double>("online_players", DefaultPluginMetrics::playerCount));
            analytics.registerNumberMetric(new MetricSupplier<Double>("amount_plugins", DefaultPluginMetrics::pluginCount));
            analytics.registerStringMetric(new MetricSupplier<String>("server_version", DefaultPluginMetrics::serverVersion));
            analytics.registerStringMetric(new MetricSupplier<String>("server_software", DefaultPluginMetrics::serverSoftware));
        }
    }

    private static boolean isBukkit() {
        try {
            Class.forName("org.bukkit.Bukkit");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

