/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancylib.translations.message;

import de.oliver.fancylib.translations.TextConfig;
import de.oliver.fancylib.translations.message.Message;
import de.oliver.fancylib.translations.message.SimpleMessage;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class MultiMessage
extends Message {
    private final List<String> messages;

    public MultiMessage(TextConfig config, List<String> messages) {
        super(config);
        this.messages = new ArrayList<String>(messages);
        this.applyColorPlaceholders();
    }

    @Override
    public Message replace(String placeholder, String replacement) {
        this.messages.replaceAll(s2 -> s2.replace("{" + placeholder + "}", replacement).replace("%" + placeholder + "%", replacement));
        return this;
    }

    @Override
    public Message replaceStripped(String placeholder, String replacement) {
        return this.replace(placeholder, MiniMessage.miniMessage().stripTags(replacement, this.tagResolverBuilder.build()));
    }

    @Override
    public Message withPrefix() {
        this.messages.replaceAll(s2 -> this.config.prefix() + s2);
        return this;
    }

    @Override
    public Message primary() {
        this.messages.replaceAll(s2 -> "<color:" + this.config.primaryColor() + ">" + s2);
        return this;
    }

    @Override
    public Message secondary() {
        this.messages.replaceAll(s2 -> "<color:" + this.config.secondaryColor() + ">" + s2);
        return this;
    }

    @Override
    public Message success() {
        this.messages.replaceAll(s2 -> "<color:" + this.config.successColor() + ">" + s2);
        return this;
    }

    @Override
    public Message warning() {
        this.messages.replaceAll(s2 -> "<color:" + this.config.warningColor() + ">" + s2);
        return this;
    }

    @Override
    public Message error() {
        this.messages.replaceAll(s2 -> "<color:" + this.config.errorColor() + ">" + s2);
        return this;
    }

    @Override
    public Message applyCustomPlaceholders() {
        return this;
    }

    @Override
    public Component buildComponent() {
        String joined = String.join((CharSequence)"\n", this.messages);
        return MiniMessage.miniMessage().deserialize(joined, this.tagResolverBuilder.build());
    }

    @Override
    public Message copy() {
        return new MultiMessage(this.config, this.messages);
    }

    public String build() {
        return String.join((CharSequence)"\n", this.messages);
    }

    public List<String> getRawMessages() {
        return this.messages;
    }

    public List<SimpleMessage> getSimpleMessages() {
        ArrayList<SimpleMessage> messages = new ArrayList<SimpleMessage>();
        for (String s2 : this.messages) {
            messages.add(new SimpleMessage(this.config, s2));
        }
        return messages;
    }

    public MultiMessage page(int page, int messagesPerPage) {
        ArrayList<String> pageMessages = new ArrayList<String>();
        int start = (page - 1) * messagesPerPage;
        int end = Math.min(start + messagesPerPage, this.messages.size());
        for (int i = start; i < end; ++i) {
            pageMessages.add(this.messages.get(i));
        }
        return new MultiMessage(this.config, pageMessages);
    }

    public int getPages(int messagesPerPage) {
        return (int)Math.ceil((double)this.messages.size() / (double)messagesPerPage);
    }
}

