/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.api;

import de.oliver.fancynpcs.api.Npc;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.entity.EntityType;

public class NpcAttribute {
    private final String name;
    private final List<String> possibleValues;
    private final List<EntityType> types;
    private final BiConsumer<Npc, String> applyFunc;

    public NpcAttribute(String name, List<String> possibleValues, List<EntityType> types, BiConsumer<Npc, String> applyFunc) {
        this.name = name;
        this.possibleValues = possibleValues;
        this.types = types;
        this.applyFunc = applyFunc;
    }

    public boolean isValidValue(String value) {
        if (this.possibleValues.isEmpty()) {
            return true;
        }
        for (String pv : this.possibleValues) {
            if (!pv.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public void apply(Npc npc, String value) {
        this.applyFunc.accept(npc, value);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPossibleValues() {
        return this.possibleValues;
    }

    public List<EntityType> getTypes() {
        return this.types;
    }
}

