/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotation.specifier.Greedy;
import de.oliver.cloud.annotations.Argument;
import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.actions.ActionTrigger;
import de.oliver.fancynpcs.api.actions.NpcAction;
import de.oliver.fancynpcs.commands.npc.DisplayNameCMD;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ActionCMD {
    INSTANCE;

    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    @Command(value="npc action <npc> <trigger> add <actionType> [value]")
    @Permission(value={"fancynpcs.command.npc.action.add"})
    public void onActionAdd(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger, @NotNull NpcAction actionType, @Greedy @Nullable String value) {
        if (!this.checkAddPermissions(sender, actionType)) {
            return;
        }
        if (value != null && DisplayNameCMD.INSTANCE.hasBlockedCommands(value)) {
            this.translator.translate("command_input_contains_blocked_command").send(sender);
            return;
        }
        if (actionType.requiresValue() && (value == null || value.isEmpty())) {
            this.translator.translate("npc_action_requires_value").send(sender);
            return;
        }
        List currentActions = npc.getData().getActions().getOrDefault((Object)trigger, new ArrayList());
        npc.getData().addAction(trigger, currentActions.size() + 1, actionType, value);
        this.translator.translate("npc_action_add_success").replaceStripped("total", String.valueOf(npc.getData().getActions(trigger).size())).send(sender);
        if (actionType.getName().equalsIgnoreCase("player_command_as_op")) {
            this.translator.translate("npc_action_add_op_warning").send(sender);
        }
    }

    @Command(value="npc action <npc> <trigger> add_before <index> <actionType> [value]")
    @Permission(value={"fancynpcs.command.npc.action.addBefore"})
    public void onActionAddBefore(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger, @Argument(suggestions="ActionCMD/number_range") int index, @NotNull NpcAction actionType, @Greedy @Nullable String value) {
        if (!this.checkAddPermissions(sender, actionType)) {
            return;
        }
        if (value != null && DisplayNameCMD.INSTANCE.hasBlockedCommands(value)) {
            this.translator.translate("command_input_contains_blocked_command").send(sender);
            return;
        }
        if (actionType.requiresValue() && (value == null || value.isEmpty())) {
            this.translator.translate("npc_action_requires_value").send(sender);
            return;
        }
        List<NpcAction.NpcActionData> currentActions = npc.getData().getActions(trigger);
        currentActions.add(Math.clamp((long)(index - 1), 0, currentActions.size()), new NpcAction.NpcActionData(index, actionType, value));
        npc.getData().setActions(trigger, this.reorderActions(currentActions));
        this.translator.translate("npc_action_add_before_success").replaceStripped("number", String.valueOf(index)).replaceStripped("total", String.valueOf(npc.getData().getActions(trigger).size())).send(sender);
        if (actionType.getName().equalsIgnoreCase("player_command_as_op")) {
            this.translator.translate("npc_action_add_op_warning").send(sender);
        }
    }

    @Command(value="npc action <npc> <trigger> add_after <index> <actionType> [value]")
    @Permission(value={"fancynpcs.command.npc.action.addAfter"})
    public void onActionAddAfter(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger, @Argument(suggestions="ActionCMD/number_range") int index, @NotNull NpcAction actionType, @Greedy @Nullable String value) {
        if (!this.checkAddPermissions(sender, actionType)) {
            return;
        }
        if (value != null && DisplayNameCMD.INSTANCE.hasBlockedCommands(value)) {
            this.translator.translate("command_input_contains_blocked_command").send(sender);
            return;
        }
        if (actionType.requiresValue() && (value == null || value.isEmpty())) {
            this.translator.translate("npc_action_requires_value").send(sender);
            return;
        }
        List<NpcAction.NpcActionData> currentActions = npc.getData().getActions(trigger);
        currentActions.add(Math.clamp((long)index, 0, currentActions.size() + 1), new NpcAction.NpcActionData(index, actionType, value));
        npc.getData().setActions(trigger, this.reorderActions(currentActions));
        this.translator.translate("npc_action_add_after_success").replaceStripped("number", String.valueOf(index)).replaceStripped("total", String.valueOf(npc.getData().getActions(trigger).size())).send(sender);
        if (actionType.getName().equalsIgnoreCase("player_command_as_op")) {
            this.translator.translate("npc_action_add_op_warning").send(sender);
        }
    }

    @Command(value="npc action <npc> <trigger> set <number> <actionType> [value]")
    @Permission(value={"fancynpcs.command.npc.action.set"})
    public void onActionSet(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger, @Argument(suggestions="ActionCMD/number_range") @NotNull Integer number, @NotNull NpcAction actionType, @Greedy @Nullable String value) {
        if (!this.checkAddPermissions(sender, actionType)) {
            return;
        }
        if (value != null && DisplayNameCMD.INSTANCE.hasBlockedCommands(value)) {
            this.translator.translate("command_input_contains_blocked_command").send(sender);
            return;
        }
        if (actionType.requiresValue() && (value == null || value.isEmpty())) {
            this.translator.translate("npc_action_requires_value").send(sender);
            return;
        }
        List<NpcAction.NpcActionData> currentActions = npc.getData().getActions(trigger);
        if (number < 1 || number > currentActions.size()) {
            this.translator.translate("npc_action_set_failure").replaceStripped("number", String.valueOf(number)).send(sender);
            return;
        }
        currentActions.set(number - 1, new NpcAction.NpcActionData(number, actionType, value));
        npc.getData().setActions(trigger, currentActions);
        this.translator.translate("npc_action_set_success").replaceStripped("number", String.valueOf(number)).replaceStripped("total", String.valueOf(npc.getData().getActions(trigger).size())).send(sender);
        if (actionType.getName().equalsIgnoreCase("player_command_as_op")) {
            this.translator.translate("npc_action_add_op_warning").send(sender);
        }
    }

    @Command(value="npc action <npc> <trigger> remove <number>")
    @Permission(value={"fancynpcs.command.npc.action.remove"})
    public void onActionRemove(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger, @Argument(suggestions="ActionCMD/number_range") int number) {
        List<NpcAction.NpcActionData> currentActions = npc.getData().getActions(trigger);
        if (number < 1 || number > currentActions.size()) {
            this.translator.translate("npc_action_remove_failure").replaceStripped("number", String.valueOf(number)).send(sender);
            return;
        }
        currentActions.remove(number - 1);
        npc.getData().setActions(trigger, this.reorderActions(currentActions));
        this.translator.translate("npc_action_remove_success").replaceStripped("number", String.valueOf(number)).replaceStripped("total", String.valueOf(npc.getData().getActions(trigger).size())).send(sender);
    }

    @Command(value="npc action <npc> <trigger> move_up <number>")
    @Permission(value={"fancynpcs.command.npc.action.moveUp"})
    public void onActionMoveUp(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger, @Argument(suggestions="ActionCMD/number_range") int number) {
        List<NpcAction.NpcActionData> currentActions = npc.getData().getActions(trigger);
        if (number <= 1) {
            this.translator.translate("npc_action_move_up_failure").replaceStripped("number", String.valueOf(number)).send(sender);
            return;
        }
        NpcAction.NpcActionData action = currentActions.get(number - 1);
        currentActions.remove(number - 1);
        currentActions.add(number - 2, action);
        npc.getData().setActions(trigger, this.reorderActions(currentActions));
        this.translator.translate("npc_action_move_up_success").replaceStripped("number", String.valueOf(number)).send(sender);
    }

    @Command(value="npc action <npc> <trigger> move_down <number>")
    @Permission(value={"fancynpcs.command.npc.action.moveDown"})
    public void onActionMoveDown(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger, @Argument(suggestions="ActionCMD/number_range") int number) {
        List<NpcAction.NpcActionData> currentActions = npc.getData().getActions(trigger);
        if (number >= currentActions.size()) {
            this.translator.translate("npc_action_move_down_failure").replaceStripped("number", String.valueOf(number)).send(sender);
            return;
        }
        NpcAction.NpcActionData action = currentActions.get(number - 1);
        currentActions.remove(number - 1);
        currentActions.add(number, action);
        npc.getData().setActions(trigger, this.reorderActions(currentActions));
        this.translator.translate("npc_action_move_down_success").replaceStripped("number", String.valueOf(number)).send(sender);
    }

    @Command(value="npc action <npc> <trigger> clear")
    @Permission(value={"fancynpcs.command.npc.action.clear"})
    public void onActionClear(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger) {
        npc.getData().setActions(trigger, new ArrayList<NpcAction.NpcActionData>());
        this.translator.translate("npc_action_clear_success").send(sender);
    }

    @Command(value="npc action <npc> <trigger> list")
    @Permission(value={"fancynpcs.command.npc.action.list"})
    public void onActionList(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull ActionTrigger trigger) {
        List<NpcAction.NpcActionData> actions = npc.getData().getActions(trigger);
        if (actions.isEmpty()) {
            this.translator.translate("npc_action_list_failure_empty").send(sender);
            return;
        }
        this.translator.translate("npc_action_list_header").replaceStripped("trigger", trigger.name()).send(sender);
        for (int i = 0; i < actions.size(); ++i) {
            NpcAction.NpcActionData action = actions.get(i);
            this.translator.translate("npc_action_list_entry").replaceStripped("number", String.valueOf(action.order())).replaceStripped("action", action.action().getName()).replaceStripped("value", action.value() != null ? action.value() : "").send(sender);
        }
        this.translator.translate("npc_action_list_footer").replaceStripped("total", String.valueOf(actions.size())).send(sender);
    }

    private List<NpcAction.NpcActionData> reorderActions(List<NpcAction.NpcActionData> actions) {
        ArrayList<NpcAction.NpcActionData> newActions = new ArrayList<NpcAction.NpcActionData>();
        for (int i = 0; i < actions.size(); ++i) {
            NpcAction.NpcActionData a = actions.get(i);
            newActions.add(new NpcAction.NpcActionData(i + 1, a.action(), a.value()));
        }
        return newActions;
    }

    private boolean checkAddPermissions(CommandSender sender, NpcAction action) {
        boolean hasGeneralPerms = sender.hasPermission("fancynpcs.command.npc.action.add.*");
        boolean hasSpecificPerms = sender.hasPermission("fancynpcs.command.npc.action.add." + action.getName());
        if (hasGeneralPerms || hasSpecificPerms) {
            return true;
        }
        this.translator.translate("action_missing_permissions").send(sender);
        return false;
    }

    @Suggestions(value="ActionCMD/number_range")
    public List<String> suggestNumber(CommandContext<CommandSender> context, CommandInput input) {
        Npc npc = context.getOrDefault("npc", null);
        ActionTrigger trigger = context.getOrDefault("trigger", null);
        if (npc == null || trigger == null) {
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int i = 0; i < npc.getData().getActions(trigger).size(); ++i) {
            suggestions.add(String.valueOf(i + 1));
        }
        return suggestions;
    }
}

