/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Argument;
import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.cloud.annotations.parser.Parser;
import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancylib.translations.message.SimpleMessage;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.events.NpcModifyEvent;
import de.oliver.fancynpcs.api.utils.NpcEquipmentSlot;
import de.oliver.fancynpcs.commands.exceptions.ReplyingParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EquipmentCMD {
    INSTANCE;

    private static final List<String> SLOT_SUGGESTIONS;
    private static final List<String> MATERIAL_SUGGESTIONS;
    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    @Command(value="npc equipment <npc> set <slot> <item>")
    @Permission(value={"fancynpcs.command.npc.equipment.set"})
    public void onEquipmentSet(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull NpcEquipmentSlot slot, @Argument(parserName="EquipmentCMD/item") @NotNull ItemStack item) {
        if (new NpcModifyEvent(npc, NpcModifyEvent.NpcModification.EQUIPMENT, new Object[]{slot, item}, sender).callEvent()) {
            npc.getData().addEquipment(slot, item);
            npc.updateForAll();
            this.translator.translate(item.getType() != Material.AIR ? "npc_equipment_set_item" : "npc_equipment_set_empty").replace("npc", npc.getData().getName()).replace("slot", this.getTranslatedSlot(slot)).addTagResolver((TagResolver)Placeholder.component((String)"item", (ComponentLike)(item.getType() != Material.AIR ? item.displayName().hoverEvent((HoverEventSource)item.asHoverEvent()) : Component.empty()))).send(sender);
        } else {
            this.translator.translate("command_npc_modification_cancelled").send(sender);
        }
    }

    @Command(value="npc equipment <npc> clear")
    @Permission(value={"fancynpcs.command.npc.equipment.clear"})
    public void onEquipmentClear(@NotNull CommandSender sender, @NotNull Npc npc) {
        if (new NpcModifyEvent(npc, NpcModifyEvent.NpcModification.EQUIPMENT, null, sender).callEvent()) {
            for (NpcEquipmentSlot slot : NpcEquipmentSlot.values()) {
                npc.getData().getEquipment().put(slot, new ItemStack(Material.AIR));
            }
            npc.updateForAll();
            this.translator.translate("npc_equipment_clear_success").replace("npc", npc.getData().getName()).send(sender);
        } else {
            this.translator.translate("command_npc_modification_cancelled").send(sender);
        }
    }

    @Command(value="npc equipment <npc> list")
    @Permission(value={"fancynpcs.command.npc.equipment.list"})
    public void onEquipmentList(@NotNull CommandSender sender, @NotNull Npc npc) {
        if (npc.getData().getEquipment().isEmpty() || npc.getData().getEquipment().values().stream().allMatch(item -> item == null || item.getType() == Material.AIR)) {
            this.translator.translate("npc_equipment_list_failure_empty").send(sender);
            return;
        }
        this.translator.translate("npc_equipment_list_header").send(sender);
        npc.getData().getEquipment().forEach((slot, item) -> {
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            this.translator.translate("npc_equipment_list_entry").replace("slot", this.getTranslatedSlot((NpcEquipmentSlot)((Object)slot))).addTagResolver((TagResolver)Placeholder.component((String)"item", (ComponentLike)item.displayName().hoverEvent((HoverEventSource)item.asHoverEvent()))).send(sender);
        });
        this.translator.translate("npc_equipment_list_footer").send(sender);
    }

    @Parser(name="", suggestions="EquipmentCMD/slot")
    public NpcEquipmentSlot parseSlot(CommandContext<CommandSender> context, CommandInput input) {
        String value = input.readString().toLowerCase();
        @Nullable NpcEquipmentSlot slot = NpcEquipmentSlot.parse(value);
        if (slot == null) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_equipment_slot").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        return slot;
    }

    @Parser(name="EquipmentCMD/item", suggestions="EquipmentCMD/item")
    public ItemStack parseItem(CommandContext<CommandSender> context, CommandInput input) {
        CommandSender commandSender;
        String value = input.readString().toLowerCase();
        if (value.equals("@none")) {
            return new ItemStack(Material.AIR);
        }
        if (value.equals("@hand") && (commandSender = context.sender()) instanceof Player) {
            Player player = (Player)commandSender;
            return player.getInventory().getItemInMainHand().clone();
        }
        @Nullable NamespacedKey key = NamespacedKey.fromString((String)value);
        if (key == null) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_material").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        @Nullable Material material = (Material)Registry.MATERIAL.get(key);
        if (material == null || !material.isItem()) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_material").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        return new ItemStack(material);
    }

    @Suggestions(value="EquipmentCMD/item")
    public List<String> suggestItem(final CommandContext<CommandSender> context, CommandInput input) {
        return new ArrayList<String>(MATERIAL_SUGGESTIONS){
            {
                super(c);
                this.add("@none");
                if (context.sender() instanceof Player) {
                    this.add("@hand");
                }
            }
        };
    }

    @Suggestions(value="EquipmentCMD/slot")
    public List<String> suggestSlot(CommandContext<CommandSender> context, CommandInput input) {
        return SLOT_SUGGESTIONS;
    }

    @NotNull
    private String getTranslatedSlot(@NotNull NpcEquipmentSlot slot) {
        return ((SimpleMessage)this.translator.translate(switch (slot) {
            default -> throw new MatchException(null, null);
            case NpcEquipmentSlot.MAINHAND -> "main_hand";
            case NpcEquipmentSlot.OFFHAND -> "off_hand";
            case NpcEquipmentSlot.HEAD -> "head";
            case NpcEquipmentSlot.CHEST -> "chest";
            case NpcEquipmentSlot.LEGS -> "legs";
            case NpcEquipmentSlot.FEET -> "feet";
        })).getMessage();
    }

    static {
        SLOT_SUGGESTIONS = Arrays.stream(NpcEquipmentSlot.values()).map(slot -> slot.name().toLowerCase()).toList();
        MATERIAL_SUGGESTIONS = StreamSupport.stream(Registry.MATERIAL.spliterator(), false).filter(Material::isItem).map(material -> material.key().asString()).toList();
    }
}

