/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.libs.chatcolorhandler.parsers.custom;

import de.oliver.fancynpcs.libs.chatcolorhandler.messengers.MiniMessageMessenger;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Parser;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.ParserTypes;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Resolver;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MiniMessageResolverParser
implements Parser {
    public static final MiniMessageResolverParser INSTANCE = new MiniMessageResolverParser();

    private MiniMessageResolverParser() {
    }

    @Override
    public String getType() {
        return "placeholder";
    }

    @Override
    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType) {
        return this.parseString(string, outputType, null);
    }

    @Override
    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType, Player player) {
        return switch (outputType) {
            default -> throw new MatchException(null, null);
            case Parser.OutputType.SPIGOT -> {
                string = string.replace('\u00a7', '&');
                Audience audience = player instanceof Audience ? (Audience)player : null;
                TagResolver resolver = Resolver.combineResolvers(audience, MiniMessageResolverParser.getPlaceholderResolvers());
                Component parsed = audience != null ? MiniMessageMessenger.MINI_MESSAGE.deserialize(string, (Pointered)audience, resolver) : MiniMessageMessenger.MINI_MESSAGE.deserialize(string, resolver);
                yield MiniMessageMessenger.LEGACY_COMPONENT_SERIALIZER.serialize(parsed);
            }
            case Parser.OutputType.MINI_MESSAGE -> string;
        };
    }

    private static List<Resolver> getPlaceholderResolvers() {
        return ParserTypes.placeholder().stream().map(parser -> {
            Resolver parserResolver;
            return parser instanceof Resolver ? (parserResolver = (Resolver)parser) : null;
        }).filter(Objects::nonNull).toList();
    }
}

