/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.tracker;

import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.events.NpcStartLookingEvent;
import de.oliver.fancynpcs.api.events.NpcStopLookingEvent;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TurnToPlayerTracker
implements Runnable {
    @Override
    public void run() {
        Collection<Npc> npcs = FancyNpcs.getInstance().getNpcManagerImpl().getAllNpcs();
        int defaultTurnToPlayerDistance = FancyNpcs.getInstance().getFancyNpcConfig().getTurnToPlayerDistance();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location playerLocation = player.getLocation();
            for (Npc npc : npcs) {
                int effectiveTurnDistance;
                double distance;
                NpcData npcData = npc.getData();
                Location npcLocation = npcData.getLocation();
                if (npcLocation == null || !npcLocation.getWorld().getName().equalsIgnoreCase(playerLocation.getWorld().getName()) || Double.isNaN(distance = playerLocation.distance(npcLocation))) continue;
                int npcTurnDistance = npcData.getTurnToPlayerDistance();
                int n = effectiveTurnDistance = npcTurnDistance == -1 ? defaultTurnToPlayerDistance : npcTurnDistance;
                if (npcData.isTurnToPlayer() && distance < (double)effectiveTurnDistance) {
                    Location newLoc = playerLocation.clone();
                    newLoc.setDirection(newLoc.subtract(npcLocation).toVector());
                    npc.lookAt(player, newLoc);
                    Boolean wasPreviouslyLooking = npc.getIsLookingAtPlayer().put(player.getUniqueId(), true);
                    if (wasPreviouslyLooking != null && wasPreviouslyLooking.booleanValue()) continue;
                    FancyNpcs.getInstance().getScheduler().runTask(null, () -> Bukkit.getPluginManager().callEvent((Event)new NpcStartLookingEvent(npc, player)));
                    continue;
                }
                if (!npcData.isTurnToPlayer() || !npc.getIsLookingAtPlayer().getOrDefault(player.getUniqueId(), false).booleanValue()) continue;
                npc.getIsLookingAtPlayer().put(player.getUniqueId(), false);
                if (FancyNpcs.getInstance().getFancyNpcConfig().isTurnToPlayerResetToInitialDirection()) {
                    npc.move(player, false);
                }
                FancyNpcs.getInstance().getScheduler().runTask(null, () -> Bukkit.getPluginManager().callEvent((Event)new NpcStopLookingEvent(npc, player)));
            }
        }
    }
}

