/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_5.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_5.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.CowVariant;
import org.bukkit.entity.EntityType;

public class CowAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", CowAttributes.getCowVariantRegistry().listElementIds().map(id -> id.location().getPath()).toList(), List.of(EntityType.COW), CowAttributes::setVariant));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        Cow cow = (Cow)ReflectionHelper.getEntity(npc);
        Holder variant = (Holder)CowAttributes.getCowVariantRegistry().get(ResourceKey.create((ResourceKey)Registries.COW_VARIANT, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)value.toLowerCase()))).orElseThrow();
        cow.setVariant(variant);
    }

    private static HolderLookup.RegistryLookup<CowVariant> getCowVariantRegistry() {
        return MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.COW_VARIANT);
    }
}

