/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.cloud.internal;

import de.oliver.cloud.Command;
import de.oliver.cloud.component.CommandComponent;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
@API(status=API.Status.STABLE)
public interface CommandRegistrationHandler<C> {
    public static <C> @NonNull CommandRegistrationHandler<C> nullCommandRegistrationHandler() {
        return new NullCommandRegistrationHandler();
    }

    public boolean registerCommand(@NonNull Command<C> var1);

    @API(status=API.Status.STABLE)
    default public void unregisterRootCommand(@NonNull CommandComponent<C> rootCommand) {
    }

    @API(status=API.Status.INTERNAL, consumers={"de.oliver.cloud.*"})
    public static final class NullCommandRegistrationHandler<C>
    implements CommandRegistrationHandler<C> {
        private NullCommandRegistrationHandler() {
        }

        @Override
        public boolean registerCommand(@NonNull Command<C> command) {
            return true;
        }

        @Override
        public void unregisterRootCommand(@NonNull CommandComponent<C> rootCommand) {
        }
    }
}

