/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Argument;
import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.cloud.annotations.parser.Parser;
import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.events.NpcModifyEvent;
import de.oliver.fancynpcs.api.utils.Interval;
import de.oliver.fancynpcs.commands.exceptions.ReplyingParseException;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum InteractionCooldownCMD {
    INSTANCE;

    private final Translator translator = FancyNpcs.getInstance().getTranslator();
    private static final Pattern SPLIT_PATTERN;

    @Command(value="npc interaction_cooldown <npc> <cooldown>")
    @Permission(value={"fancynpcs.command.npc.interaction_cooldown"})
    public void onInteractionCooldown(@NotNull CommandSender sender, @NotNull Npc npc, @Argument(parserName="InteractionCooldownCMD/cooldown") @NotNull Interval cooldown) {
        if (new NpcModifyEvent(npc, NpcModifyEvent.NpcModification.INTERACTION_COOLDOWN, cooldown, sender).callEvent()) {
            npc.getData().setInteractionCooldown((float)cooldown.as(Interval.Unit.MILLISECONDS) / 1000.0f);
            this.translator.translate(cooldown.as(Interval.Unit.MILLISECONDS) != 0.0 ? "npc_interaction_cooldown_set" : "npc_interaction_cooldown_disabled").replace("npc", npc.getData().getName()).replace("time", cooldown.toString()).send(sender);
        } else {
            this.translator.translate("command_npc_modification_cancelled").send(sender);
        }
    }

    @Parser(name="InteractionCooldownCMD/cooldown", suggestions="InteractionCooldownCMD/cooldown")
    @NotNull
    public Interval parse(CommandContext<CommandSender> context, CommandInput input) {
        Interval.Unit unit;
        String value = input.readString();
        if (value.equalsIgnoreCase("disabled")) {
            return Interval.of(0L, Interval.Unit.MILLISECONDS);
        }
        String[] split = SPLIT_PATTERN.split(value);
        Long num = split.length == 2 ? this.parseLong(split[0]) : null;
        Interval.Unit unit2 = unit = split.length == 2 ? Interval.Unit.fromShortCode(split[1].toLowerCase()) : null;
        if (num == null || unit == null) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_interval").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        return Interval.of(Math.max(0L, num), unit);
    }

    @Suggestions(value="InteractionCooldownCMD/cooldown")
    @NotNull
    public Collection<String> suggest(CommandContext<CommandSender> context, CommandInput input) {
        String value = input.readString();
        String[] split = SPLIT_PATTERN.split(value);
        final @Nullable Long num = this.parseLong(split[0]);
        return num == null || num <= 0L ? List.of("30s", "5min", "8h", "disabled") : new ArrayList<String>(){
            {
                this.add("disabled");
                this.addAll(Stream.of(Pair.of((Object)Interval.of(num, Interval.Unit.MILLISECONDS), (Object)((Object)Interval.Unit.MILLISECONDS)), Pair.of((Object)Interval.of(num, Interval.Unit.SECONDS), (Object)((Object)Interval.Unit.SECONDS)), Pair.of((Object)Interval.of(num, Interval.Unit.MINUTES), (Object)((Object)Interval.Unit.MINUTES)), Pair.of((Object)Interval.of(num, Interval.Unit.HOURS), (Object)((Object)Interval.Unit.HOURS))).map(pair -> num + ((Interval.Unit)((Object)((Object)pair.second()))).getShortCode()).toList());
            }
        };
    }

    @Nullable
    private Long parseLong(@NotNull String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static {
        SPLIT_PATTERN = Pattern.compile("(?<=\\d)(?=\\D)");
    }
}

