/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.libs.chatcolorhandler.parsers.custom;

import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Parser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LegacyHexParser
implements Parser {
    public static final LegacyHexParser INSTANCE = new LegacyHexParser();
    private static final Pattern HEX_PATTERN = Pattern.compile("[\u00a7&]x[\u00a7&]([a-fA-F0-9])[\u00a7&]([a-fA-F0-9])[\u00a7&]([a-fA-F0-9])[\u00a7&]([a-fA-F0-9])[\u00a7&]([a-fA-F0-9])[\u00a7&]([a-fA-F0-9])");

    private LegacyHexParser() {
    }

    @Override
    public String getType() {
        return "color";
    }

    @Override
    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType) {
        return switch (outputType) {
            default -> throw new MatchException(null, null);
            case Parser.OutputType.SPIGOT -> string;
            case Parser.OutputType.MINI_MESSAGE -> {
                Matcher match = HEX_PATTERN.matcher(string);
                yield match.replaceAll("<reset><#$1$2$3$4$5$6>");
            }
        };
    }
}

