/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_1.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_1.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.item.DyeColor;
import org.bukkit.entity.EntityType;

public class WolfAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("pose", List.of("standing", "sitting"), List.of(EntityType.WOLF), WolfAttributes::setPose));
        attributes.add(new NpcAttribute("angry", List.of("true", "false"), List.of(EntityType.WOLF), WolfAttributes::setAngry));
        attributes.add(new NpcAttribute("variant", List.of("PALE", "SPOTTED", "SNOWY", "BLACK", "ASHEN", "RUSTY", "WOODS", "CHESTNUT", "STRIPED"), List.of(EntityType.WOLF), WolfAttributes::setVariant));
        attributes.add(new NpcAttribute("collar_color", List.of("RED", "BLUE", "YELLOW", "GREEN", "PURPLE", "ORANGE", "LIME", "MAGENTA", "BROWN", "WHITE", "GRAY", "LIGHT_GRAY", "LIGHT_BLUE", "BLACK", "CYAN", "PINK", "NONE"), List.of(EntityType.WOLF), WolfAttributes::setCollarColor));
        return attributes;
    }

    private static void setPose(Npc npc, String value) {
        Wolf wolf = (Wolf)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                wolf.setInSittingPose(false, false);
                break;
            }
            case "sitting": {
                wolf.setInSittingPose(true, false);
            }
        }
    }

    private static void setAngry(Npc npc, String value) {
        Wolf wolf = (Wolf)ReflectionHelper.getEntity(npc);
        boolean angry = Boolean.parseBoolean(value.toLowerCase());
        wolf.setRemainingPersistentAngerTime(angry ? 100 : 0);
    }

    private static void setVariant(Npc npc, String value) {
        Registry anyRegistry;
        Wolf wolf = (Wolf)ReflectionHelper.getEntity(npc);
        Registry registry = anyRegistry = wolf.level().registryAccess().registryOrThrow(Registries.WOLF_VARIANT);
        ResourceLocation variantLocation = ResourceLocation.tryParse((String)("minecraft:" + value.toLowerCase()));
        if (variantLocation == null) {
            System.out.println("Invalid variant name: " + value);
            return;
        }
        WolfVariant variant = (WolfVariant)registry.get(variantLocation);
        if (variant == null) {
            System.out.println("Wolf variant not found: " + String.valueOf(variantLocation));
            return;
        }
        registry.getResourceKey((Object)variant).ifPresentOrElse(key -> {
            Holder.Reference holder = registry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.WOLF_VARIANT, (ResourceLocation)variantLocation));
            wolf.setVariant((Holder)holder);
        }, () -> {
            System.out.println("Wolf variant key not found in registry, using direct holder (may be unsafe)");
            wolf.setVariant(Holder.direct((Object)variant));
        });
    }

    private static void setCollarColor(Npc npc, String value) {
        Wolf wolf = (Wolf)ReflectionHelper.getEntity(npc);
        if (value.equalsIgnoreCase("none") || value.isEmpty()) {
            wolf.setTame(false, false);
            return;
        }
        try {
            DyeColor color = DyeColor.valueOf((String)value.toUpperCase());
            if (!wolf.isTame()) {
                wolf.setTame(true, false);
            }
            wolf.setCollarColor(color);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid wolf collar color: " + value);
        }
    }
}

