/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancylib.databases;

import de.oliver.fancylib.databases.Database;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;

public class MySqlDatabase
implements Database {
    protected final String host;
    protected final String port;
    protected final String database;
    protected final String username;
    protected final String password;
    protected Connection connection;

    public MySqlDatabase(String host, String port, String database, String username, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.connection = null;
    }

    @Override
    public boolean connect() {
        try {
            if (this.isConnected()) {
                return true;
            }
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean close() {
        try {
            if (!this.isConnected()) {
                return true;
            }
            this.connection.close();
            this.connection = null;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean executeNonQuery(String sql) {
        try {
            this.connection.createStatement().execute(sql);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ResultSet executeQuery(String query) {
        try {
            ResultSet resultSet = this.connection.createStatement().executeQuery(query);
            return resultSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

