/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.libs.chatcolorhandler.parsers.custom;

import de.oliver.fancynpcs.libs.chatcolorhandler.messengers.MiniMessageMessenger;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Parser;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Resolver;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MiniMessageInteractionParser
implements Resolver {
    public static final MiniMessageInteractionParser INSTANCE = new MiniMessageInteractionParser();
    private static final TagResolver INTERACTION = TagResolver.builder().resolvers(new TagResolver[]{StandardTags.hoverEvent(), StandardTags.clickEvent(), StandardTags.insertion()}).build();

    private MiniMessageInteractionParser() {
    }

    @Override
    public String getType() {
        return "interaction";
    }

    @Override
    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType) {
        return switch (outputType) {
            default -> throw new MatchException(null, null);
            case Parser.OutputType.SPIGOT -> {
                string = string.replace('\u00a7', '&');
                yield MiniMessageMessenger.LEGACY_COMPONENT_SERIALIZER.serialize(MiniMessageMessenger.MINI_MESSAGE.deserialize(string, INTERACTION));
            }
            case Parser.OutputType.MINI_MESSAGE -> string;
        };
    }

    @Override
    @NotNull
    public TagResolver getResolver() {
        return INTERACTION;
    }
}

