/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_4.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_20_4.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.animal.horse.HorseStyle;
import org.bukkit.entity.EntityType;

public class HorseAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", Arrays.stream(HorseColor.values()).map(Enum::name).toList(), List.of(EntityType.HORSE), HorseAttributes::setVariant));
        attributes.add(new NpcAttribute("markings", Arrays.stream(HorseStyle.values()).map(Enum::name).toList(), List.of(EntityType.HORSE), HorseAttributes::setMarkings));
        attributes.add(new NpcAttribute("pose", List.of("eating", "rearing", "standing"), Arrays.stream(EntityType.values()).filter(type -> type.getEntityClass() != null && (type == EntityType.HORSE || type == EntityType.DONKEY || type == EntityType.MULE || type == EntityType.SKELETON_HORSE || type == EntityType.ZOMBIE_HORSE)).toList(), HorseAttributes::setPose));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        EntityHorse horse = (EntityHorse)ReflectionHelper.getEntity(npc);
        HorseColor variant = HorseColor.valueOf((String)value.toUpperCase());
        horse.a(variant);
    }

    private static void setMarkings(Npc npc, String value) {
        EntityHorse horse = (EntityHorse)ReflectionHelper.getEntity(npc);
        HorseStyle markings = HorseStyle.valueOf((String)value.toUpperCase());
        horse.a(horse.w(), markings);
    }

    private static void setPose(Npc npc, String value) {
        EntityHorseAbstract horse = (EntityHorseAbstract)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                horse.A(false);
                horse.setForceStanding(false);
                break;
            }
            case "rearing": {
                horse.setForceStanding(true);
                horse.A(false);
                break;
            }
            case "eating": {
                horse.setForceStanding(false);
                horse.A(true);
            }
        }
    }
}

