/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_11.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_11.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.animal.fox.Fox;
import org.bukkit.entity.EntityType;

public class FoxAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("type", Arrays.stream(Fox.Variant.values()).map(Enum::name).toList(), List.of(EntityType.FOX), FoxAttributes::setType));
        attributes.add(new NpcAttribute("pose", List.of("standing", "sleeping", "sitting"), List.of(EntityType.FOX), FoxAttributes::setPose));
        return attributes;
    }

    private static void setType(Npc npc, String value) {
        Fox fox = (Fox)ReflectionHelper.getEntity(npc);
        Fox.Variant type = Fox.Variant.valueOf((String)value.toUpperCase());
        fox.setVariant(type);
    }

    private static void setPose(Npc npc, String value) {
        Fox fox = (Fox)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                fox.setIsCrouching(false);
                fox.setSleeping(false);
                fox.setSitting(false, false);
                break;
            }
            case "sleeping": {
                fox.setSleeping(true);
                fox.setSitting(false, false);
                fox.setIsCrouching(false);
                break;
            }
            case "sitting": {
                fox.setSitting(true, false);
                fox.setSleeping(false);
                fox.setIsCrouching(false);
            }
        }
    }
}

