/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Argument;
import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.cloud.annotations.parser.Parser;
import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.AttributeManager;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.api.events.NpcModifyEvent;
import de.oliver.fancynpcs.commands.exceptions.ReplyingParseException;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public enum AttributeCMD {
    INSTANCE;

    private final Translator translator = FancyNpcs.getInstance().getTranslator();
    private final AttributeManager attributeManager = FancyNpcs.getInstance().getAttributeManager();

    @Command(value="npc attribute <npc> set <attribute> <attributeValue>")
    @Permission(value={"fancynpcs.command.npc.attribute.set"})
    public void onAttributeSet(@NotNull CommandSender sender, @NotNull Npc npc, @NotNull NpcAttribute attribute, @Argument(parserName="AttributeCMD/attribute_value") @NotNull String attributeValue) {
        if (new NpcModifyEvent(npc, NpcModifyEvent.NpcModification.ATTRIBUTE, new Object[]{attribute, attributeValue}, sender).callEvent()) {
            npc.getData().addAttribute(attribute, attributeValue);
            npc.updateForAll();
            this.translator.translate("npc_attribute_set").replace("attribute", attribute.getName()).replaceStripped("value", attributeValue.toLowerCase()).send(sender);
        } else {
            this.translator.translate("command_npc_modification_cancelled").send(sender);
        }
    }

    @Command(value="npc attribute <npc> list")
    @Permission(value={"fancynpcs.command.npc.attribute.list"})
    public void onAttributeList(@NotNull CommandSender sender, @NotNull Npc npc) {
        if (npc.getData().getAttributes().isEmpty()) {
            this.translator.translate("npc_attribute_list_failure_empty").send(sender);
            return;
        }
        this.translator.translate("npc_attribute_list_header").send(sender);
        npc.getData().getAttributes().forEach((attribute, value) -> this.translator.translate("npc_attribute_list_entry").replace("attribute", attribute.getName()).replace("value", (String)value).send(sender));
        this.translator.translate("npc_attribute_list_footer").send(sender);
    }

    @Parser(name="", suggestions="AttributeCMD/attribute")
    public NpcAttribute parseAttribute(CommandContext<CommandSender> context, CommandInput input) {
        Npc npc = (Npc)context.get("npc");
        String value = input.readString();
        NpcAttribute attribute = this.attributeManager.getAttributeByName(npc.getData().getType(), value);
        if (attribute == null) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_attribute").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        return attribute;
    }

    @Parser(name="AttributeCMD/attribute_value", suggestions="AttributeCMD/attribute_value")
    public String parseAttributeValue(CommandContext<CommandSender> context, CommandInput input) {
        String value;
        NpcAttribute attribute = (NpcAttribute)context.get("attribute");
        if (!attribute.isValidValue(value = input.read(input.remainingLength()))) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_attribute_value").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        return value;
    }

    @Suggestions(value="AttributeCMD/attribute")
    public List<String> suggestAttribute(CommandContext<CommandSender> context, CommandInput input) {
        Npc npc = context.getOrDefault("npc", null);
        return this.attributeManager.getAllAttributesForEntityType(npc.getData().getType()).stream().map(NpcAttribute::getName).toList();
    }

    @Suggestions(value="AttributeCMD/attribute_value")
    public List<String> suggestAttributeValue(CommandContext<CommandSender> context, CommandInput input) {
        Npc npc = (Npc)context.get("npc");
        NpcAttribute attribute = (NpcAttribute)context.get("attribute");
        return this.attributeManager.getAttributeByName(npc.getData().getType(), attribute.getName()).getPossibleValues();
    }
}

