/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.listeners;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.events.NpcCreateEvent;
import de.oliver.fancynpcs.api.events.NpcModifyEvent;
import de.oliver.fancynpcs.api.events.NpcRemoveEvent;
import java.util.Comparator;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerNpcsListener
implements Listener {
    private static final boolean isUsingPlotSquared = FancyNpcs.getInstance().isUsingPlotSquared();
    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    public static boolean checkNpcOwnership(Player player, org.bukkit.Location loc) {
        if (!isUsingPlotSquared) {
            return true;
        }
        if (loc == null || player == null) {
            return false;
        }
        if (player.hasPermission("fancynpcs.admin")) {
            return true;
        }
        Location npcLoc = Location.at((String)loc.getWorld().getName(), (int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
        PlotArea plotArea = PlotSquared.platform().plotAreaManager().getPlotArea(npcLoc);
        if (plotArea == null) {
            return false;
        }
        Plot plot = plotArea.getOwnedPlot(npcLoc);
        return plot != null && plot.isOwner(player.getUniqueId());
    }

    @EventHandler
    public void onNpcCreate(NpcCreateEvent event) {
        CommandSender commandSender = event.getCreator();
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        boolean isOwner = PlayerNpcsListener.checkNpcOwnership(player, event.getNpc().getData().getLocation());
        if (!isOwner) {
            this.translator.translate("player_npcs_create_failure_not_owned_plot").send((CommandSender)player);
            event.setCancelled(true);
            return;
        }
        int maxNpcs = FancyNpcs.getInstance().getFancyNpcConfig().getMaxNpcsPerPermission().entrySet().stream().filter(entry -> player.hasPermission((String)entry.getKey())).max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getValue).orElse(Integer.MAX_VALUE);
        int npcAmount = 0;
        for (Npc npc : FancyNpcs.getInstance().getNpcManager().getAllNpcs()) {
            if (!npc.getData().getCreator().equals(player.getUniqueId())) continue;
            ++npcAmount;
        }
        if (npcAmount >= maxNpcs && !player.hasPermission("fancynpcs.admin")) {
            this.translator.translate("player_npcs_create_failure_limit_reached").send((CommandSender)player);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onNpcRemove(NpcRemoveEvent event) {
        CommandSender commandSender = event.getSender();
        if (!(commandSender instanceof Player)) {
            FancyNpcs.getInstance().getFancyLogger().warn("NpcRemoveEvent sender is not a Player!", new Property[0]);
            return;
        }
        Player player = (Player)commandSender;
        if (!event.getNpc().getData().getCreator().equals(player.getUniqueId()) && !player.hasPermission("fancynpcs.admin")) {
            this.translator.translate("player_npcs_cannot_modify_npc").send((CommandSender)player);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onNpcModify(NpcModifyEvent event) {
        CommandSender commandSender = event.getModifier();
        if (!(commandSender instanceof Player)) {
            FancyNpcs.getInstance().getFancyLogger().warn("NpcModifyEvent modifier is not a Player!", new Property[0]);
            return;
        }
        Player player = (Player)commandSender;
        Object object = event.getNewValue();
        if (!(object instanceof org.bukkit.Location)) {
            FancyNpcs.getInstance().getFancyLogger().warn("NpcModifyEvent newValue is not a Location!", new Property[0]);
            return;
        }
        org.bukkit.Location location = (org.bukkit.Location)object;
        boolean isOwner = PlayerNpcsListener.checkNpcOwnership(player, location);
        if (!isOwner) {
            this.translator.translate("player_npcs_cannot_move_npc").send((CommandSender)player);
            event.setCancelled(true);
        }
    }
}

