/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_11.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_11.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.entity.EntityType;

public class LivingEntityAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("use_item", List.of("main_hand", "off_hand", "none"), Arrays.stream(EntityType.values()).filter(type -> type.getEntityClass() != null && org.bukkit.entity.LivingEntity.class.isAssignableFrom(type.getEntityClass())).toList(), LivingEntityAttributes::setUseItem));
        return attributes;
    }

    private static void setHurt(Npc npc, String value) {
        LivingEntity livingEntity = (LivingEntity)ReflectionHelper.getEntity(npc);
        boolean isHurt = Boolean.parseBoolean(value);
        if (isHurt) {
            livingEntity.hurtDuration = 1;
            livingEntity.hurtTime = 1;
            livingEntity.hurtMarked = true;
            livingEntity.animateHurt(0.0f);
        } else {
            livingEntity.hurtDuration = 0;
            livingEntity.hurtTime = 0;
            livingEntity.hurtMarked = false;
        }
    }

    private static void setUseItem(Npc npc, String value) {
        LivingEntity livingEntity = (LivingEntity)ReflectionHelper.getEntity(npc);
        switch (value.toUpperCase()) {
            case "NONE": {
                livingEntity.stopUsingItem();
                break;
            }
            case "MAIN_HAND": {
                livingEntity.startUsingItem(InteractionHand.MAIN_HAND, true);
                break;
            }
            case "OFF_HAND": {
                livingEntity.startUsingItem(InteractionHand.OFF_HAND, true);
            }
        }
    }
}

