/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyanalytics.sdk.metrics.defaults;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;

public class DefaultSystemMetrics {
    public static String operatingSystem() {
        return System.getProperty("os.name");
    }

    public static String operatingSystemVersion() {
        return System.getProperty("os.version");
    }

    public static String operatingSystemArchitecture() {
        return System.getProperty("os.arch");
    }

    public static double cpuCoreCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String javaVersion() {
        return System.getProperty("java.version");
    }

    public static String jvmName() {
        return System.getProperty("java.vm.name");
    }

    public static double maxMemoryGB() {
        return (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0 / 1024.0;
    }

    public static double usedMemoryGB() {
        return (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
    }

    public static double usedMemoryPercentage() {
        return (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / (double)Runtime.getRuntime().maxMemory();
    }

    public static double cpuUsage() {
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
            return sunOsBean.getCpuLoad();
        }
        return 0.0;
    }

    public static double freeDiskSpaceGB() {
        return (double)new File("/").getFreeSpace() / 1024.0 / 1024.0 / 1024.0;
    }

    public static double usedDiskSpaceGB() {
        return (double)(new File("/").getTotalSpace() - new File("/").getFreeSpace()) / 1024.0 / 1024.0 / 1024.0;
    }

    public static double usedDiskSpacePercentage() {
        return (double)(new File("/").getTotalSpace() - new File("/").getFreeSpace()) / (double)new File("/").getTotalSpace();
    }

    public static double uptimeSeconds() {
        return (double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0;
    }
}

