/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands;

import de.oliver.cloud.annotations.AnnotationParser;
import de.oliver.cloud.bukkit.CloudBukkitCapabilities;
import de.oliver.cloud.bukkit.parser.WorldParser;
import de.oliver.cloud.bukkit.parser.location.LocationParser;
import de.oliver.cloud.component.CommandComponent;
import de.oliver.cloud.exception.ArgumentParseException;
import de.oliver.cloud.exception.InvalidCommandSenderException;
import de.oliver.cloud.exception.InvalidSyntaxException;
import de.oliver.cloud.exception.NoPermissionException;
import de.oliver.cloud.exception.handling.ExceptionHandler;
import de.oliver.cloud.exception.handling.ExceptionHandlerRegistration;
import de.oliver.cloud.exception.parsing.NumberParseException;
import de.oliver.cloud.exception.parsing.ParserException;
import de.oliver.cloud.execution.ExecutionCoordinator;
import de.oliver.cloud.paper.LegacyPaperCommandManager;
import de.oliver.cloud.parser.standard.BooleanParser;
import de.oliver.cloud.parser.standard.EnumParser;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancylib.translations.message.Message;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.commands.FancyNpcsCMD;
import de.oliver.fancynpcs.commands.FancyNpcsDebugCMD;
import de.oliver.fancynpcs.commands.arguments.ActionTriggerArgument;
import de.oliver.fancynpcs.commands.arguments.ActionTypeArgument;
import de.oliver.fancynpcs.commands.arguments.LocationArgument;
import de.oliver.fancynpcs.commands.arguments.NpcArgument;
import de.oliver.fancynpcs.commands.exceptions.ReplyingParseException;
import de.oliver.fancynpcs.commands.npc.ActionCMD;
import de.oliver.fancynpcs.commands.npc.AttributeCMD;
import de.oliver.fancynpcs.commands.npc.CenterCMD;
import de.oliver.fancynpcs.commands.npc.CollidableCMD;
import de.oliver.fancynpcs.commands.npc.CopyCMD;
import de.oliver.fancynpcs.commands.npc.CreateCMD;
import de.oliver.fancynpcs.commands.npc.DisplayNameCMD;
import de.oliver.fancynpcs.commands.npc.EquipmentCMD;
import de.oliver.fancynpcs.commands.npc.FixCMD;
import de.oliver.fancynpcs.commands.npc.GlowingCMD;
import de.oliver.fancynpcs.commands.npc.HelpCMD;
import de.oliver.fancynpcs.commands.npc.InfoCMD;
import de.oliver.fancynpcs.commands.npc.InteractionCooldownCMD;
import de.oliver.fancynpcs.commands.npc.ListCMD;
import de.oliver.fancynpcs.commands.npc.MoveHereCMD;
import de.oliver.fancynpcs.commands.npc.MoveToCMD;
import de.oliver.fancynpcs.commands.npc.NearbyCMD;
import de.oliver.fancynpcs.commands.npc.RemoveCMD;
import de.oliver.fancynpcs.commands.npc.RotateCMD;
import de.oliver.fancynpcs.commands.npc.ScaleCMD;
import de.oliver.fancynpcs.commands.npc.ShowInTabCMD;
import de.oliver.fancynpcs.commands.npc.SkinCMD;
import de.oliver.fancynpcs.commands.npc.TeleportCMD;
import de.oliver.fancynpcs.commands.npc.TurnToPlayerCMD;
import de.oliver.fancynpcs.commands.npc.TurnToPlayerDistanceCMD;
import de.oliver.fancynpcs.commands.npc.TypeCMD;
import de.oliver.fancynpcs.commands.npc.VisibilityDistanceCMD;
import de.oliver.fancynpcs.utils.GlowingColor;
import io.leangen.geantyref.TypeToken;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloudCommandManager {
    @NotNull
    private final FancyNpcs plugin;
    @NotNull
    private final LegacyPaperCommandManager<CommandSender> commandManager;
    @NotNull
    private final AnnotationParser<CommandSender> annotationParser;

    public CloudCommandManager(@NotNull FancyNpcs plugin, boolean isBrigadier) {
        this.plugin = plugin;
        this.commandManager = LegacyPaperCommandManager.createNative((Plugin)plugin, ExecutionCoordinator.simpleCoordinator());
        if (isBrigadier && this.commandManager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            this.commandManager.registerBrigadier();
        }
        this.annotationParser = new AnnotationParser<CommandSender>(this.commandManager, CommandSender.class);
    }

    @NotNull
    public CloudCommandManager registerArguments() {
        this.annotationParser.parse(NpcArgument.INSTANCE);
        this.annotationParser.parse(new Object[]{LocationArgument.INSTANCE});
        this.annotationParser.parse(ActionTriggerArgument.INSTANCE);
        this.annotationParser.parse(ActionTypeArgument.INSTANCE);
        return this;
    }

    @NotNull
    public CloudCommandManager registerExceptionHandlers() {
        Translator translator = this.plugin.getTranslator();
        this.commandManager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(NumberParseException.class));
        this.commandManager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(BooleanParser.BooleanParseException.class));
        this.commandManager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(EnumParser.EnumParseException.class));
        this.commandManager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(WorldParser.WorldParseException.class));
        this.commandManager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(ReplyingParseException.class));
        this.commandManager.exceptionController().registerHandler(NoPermissionException.class, exceptionContext -> translator.translate("command_missing_permissions").send((CommandSender)exceptionContext.context().sender()));
        this.commandManager.exceptionController().registerHandler(InvalidCommandSenderException.class, exceptionContext -> translator.translate("command_player_only").send((CommandSender)exceptionContext.context().sender()));
        this.commandManager.exceptionController().registerHandler(NumberParseException.class, exceptionContext -> translator.translate("command_invalid_number").replaceStripped("input", ((NumberParseException)exceptionContext.exception()).input()).replace("min", ((NumberParseException)exceptionContext.exception()).range().min().toString()).replace("max", ((NumberParseException)exceptionContext.exception()).range().max().toString()).send((CommandSender)exceptionContext.context().sender()));
        this.commandManager.exceptionController().registerHandler(BooleanParser.BooleanParseException.class, exceptionContext -> translator.translate("command_invalid_boolean").replaceStripped("input", ((BooleanParser.BooleanParseException)exceptionContext.exception()).input()).send((CommandSender)exceptionContext.context().sender()));
        this.commandManager.exceptionController().registerHandler(WorldParser.WorldParseException.class, exceptionContext -> translator.translate("command_invalid_world").replaceStripped("input", ((WorldParser.WorldParseException)exceptionContext.exception()).input()).send((CommandSender)exceptionContext.context().sender()));
        this.commandManager.exceptionController().register(ExceptionHandlerRegistration.builder(TypeToken.get(ArgumentParseException.class)).exceptionFilter(exception -> {
            ParserException parserException;
            Throwable patt0$temp = exception.getCause();
            return patt0$temp instanceof ParserException && (parserException = (ParserException)patt0$temp).argumentParserClass() == LocationParser.class;
        }).exceptionHandler(exceptionContext -> {
            ParserException exception = (ParserException)((ArgumentParseException)exceptionContext.exception()).getCause();
            String input = exception.captionVariables()[0].value();
            translator.translate("command_invalid_location").replaceStripped("input", !input.isBlank() ? input : "N/A").send((CommandSender)exceptionContext.context().sender());
        }).build());
        this.commandManager.exceptionController().registerHandler(EnumParser.EnumParseException.class, exceptionContext -> {
            String translationKey = "command_invalid_enum_generic";
            if (((EnumParser.EnumParseException)exceptionContext.exception()).enumClass() == ListCMD.SortType.class) {
                translationKey = "command_invalid_list_sort_type";
            } else if (((EnumParser.EnumParseException)exceptionContext.exception()).enumClass() == NearbyCMD.SortType.class) {
                translationKey = "command_invalid_nearby_sort_type";
            } else if (((EnumParser.EnumParseException)exceptionContext.exception()).enumClass() == EntityType.class) {
                translationKey = "command_invalid_entity_type";
            } else if (((EnumParser.EnumParseException)exceptionContext.exception()).enumClass() == GlowingColor.class) {
                translationKey = "command_invalid_glowing_color";
            }
            translator.translate(translationKey).replaceStripped("input", ((EnumParser.EnumParseException)exceptionContext.exception()).input()).replace("enum", ((EnumParser.EnumParseException)exceptionContext.exception()).enumClass().getSimpleName().toLowerCase()).send((CommandSender)exceptionContext.context().sender());
        });
        this.commandManager.exceptionController().registerHandler(ReplyingParseException.class, context -> ((ReplyingParseException)context.exception()).runnable().run());
        this.commandManager.exceptionController().registerHandler(InvalidSyntaxException.class, exceptionContext -> {
            StringBuilder translationKeyBuilder = new StringBuilder("command_syntax.");
            ((InvalidSyntaxException)exceptionContext.exception()).currentChain().stream().filter(c -> c.type() == CommandComponent.ComponentType.LITERAL).forEach(literal -> translationKeyBuilder.append(literal.name()).append(' '));
            String translationKey = translationKeyBuilder.toString().trim().replace(' ', '_');
            @Nullable Message message = Optional.ofNullable(this.plugin.getTranslator().getSelectedLanguage().getMessage(translationKey)).orElse(this.plugin.getTranslator().getFallbackLanguage().getMessage(translationKey));
            if (message == null) {
                this.plugin.getTranslator().translate("command_invalid_syntax_generic").replace("syntax", ((InvalidSyntaxException)exceptionContext.exception()).correctSyntax()).send((CommandSender)exceptionContext.context().sender());
                return;
            }
            message.send((CommandSender)exceptionContext.context().sender());
        });
        return this;
    }

    @NotNull
    public CloudCommandManager registerCommands() {
        this.annotationParser.parse(new Object[]{AttributeCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{CenterCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{CollidableCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{CopyCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{CreateCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{DisplayNameCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{EquipmentCMD.INSTANCE});
        this.annotationParser.parse(FancyNpcsCMD.INSTANCE);
        this.annotationParser.parse(new Object[]{FixCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{GlowingCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{InfoCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{InteractionCooldownCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{ListCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{MoveHereCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{MoveToCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{NearbyCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{HelpCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{RemoveCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{RotateCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{ShowInTabCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{SkinCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{TeleportCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{TurnToPlayerCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{TurnToPlayerDistanceCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{TypeCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{ActionCMD.INSTANCE});
        this.annotationParser.parse(new Object[]{VisibilityDistanceCMD.INSTANCE});
        if (FancyNpcs.ENABLE_DEBUG_MODE_FEATURE_FLAG.isEnabled()) {
            this.annotationParser.parse(FancyNpcsDebugCMD.INSTANCE);
        }
        if (Set.of("1.20.5", "1.20.6", "1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8", "1.21.9", "1.21.10", "1.21.11 Release Candidate 2").contains(Bukkit.getMinecraftVersion())) {
            this.annotationParser.parse(new Object[]{ScaleCMD.INSTANCE});
        }
        return this;
    }

    @NotNull
    public LegacyPaperCommandManager<CommandSender> getCommandManager() {
        return this.commandManager;
    }

    @NotNull
    public AnnotationParser<CommandSender> getAnnotationParser() {
        return this.annotationParser;
    }
}

