/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.libs.chatcolorhandler;

import de.oliver.fancynpcs.libs.chatcolorhandler.ChatColorHandler;
import de.oliver.fancynpcs.libs.chatcolorhandler.messengers.MiniMessageMessenger;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Parser;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Resolver;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ModernChatColorHandler {
    public static Component translate(@Nullable String string) {
        return ModernChatColorHandler.translate(string, ChatColorHandler.settings().defaultParsers());
    }

    public static Component translate(@Nullable String string, @NotNull List<Parser> parsers) {
        return ModernChatColorHandler.translate(string, null, parsers);
    }

    public static Component translate(@Nullable String string, Player player) {
        return ModernChatColorHandler.translate(string, player, ChatColorHandler.settings().defaultParsers());
    }

    public static Component translate(@Nullable String string, Player player, @NotNull List<Parser> parsers) {
        ChatColorHandler.ensureInitialised();
        if (string == null || string.isBlank()) {
            return Component.empty();
        }
        String legacyParsed = ChatColorHandler.parsers().parseString(string, Parser.OutputType.MINI_MESSAGE, player, parsers);
        TagResolver tagResolver = Resolver.combineResolvers((Audience)player, parsers.stream().map(parser -> {
            Resolver resolver;
            return parser instanceof Resolver ? (resolver = (Resolver)parser) : null;
        }).filter(Objects::nonNull).toList());
        return MiniMessageMessenger.MINI_MESSAGE.deserialize(legacyParsed, tagResolver);
    }

    public static List<Component> translate(@NotNull Collection<String> strings) {
        return ModernChatColorHandler.translate(strings, ChatColorHandler.settings().defaultParsers());
    }

    public static List<Component> translate(@NotNull Collection<String> strings, List<Parser> parsers) {
        return ModernChatColorHandler.translate(strings, null, parsers);
    }

    public static List<Component> translate(@NotNull Collection<String> strings, Player player) {
        return ModernChatColorHandler.translate(strings, player, ChatColorHandler.settings().defaultParsers());
    }

    public static List<Component> translate(@NotNull Collection<String> strings, Player player, List<Parser> parsers) {
        return strings.stream().map(string -> ModernChatColorHandler.translate(string, player, parsers)).toList();
    }

    private ModernChatColorHandler() {
    }
}

