/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs;

import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.fancylib.serverSoftware.ServerSoftware;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.NpcManager;
import de.oliver.fancynpcs.api.actions.ActionTrigger;
import de.oliver.fancynpcs.api.actions.NpcAction;
import de.oliver.fancynpcs.api.data.property.NpcVisibility;
import de.oliver.fancynpcs.api.events.NpcsLoadedEvent;
import de.oliver.fancynpcs.api.skins.SkinData;
import de.oliver.fancynpcs.api.skins.SkinLoadException;
import de.oliver.fancynpcs.api.utils.NpcEquipmentSlot;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;

public class NpcManagerImpl
implements NpcManager {
    private final JavaPlugin plugin;
    private final ExtendedFancyLogger logger;
    private final Function<NpcData, Npc> npcAdapter;
    private final File npcConfigFile;
    private final Map<String, Npc> npcs;
    private boolean isLoaded;

    public NpcManagerImpl(JavaPlugin plugin, Function<NpcData, Npc> npcAdapter) {
        this.plugin = plugin;
        this.logger = FancyNpcs.getInstance().getFancyLogger();
        this.npcAdapter = npcAdapter;
        this.npcs = new ConcurrentHashMap<String, Npc>();
        this.npcConfigFile = new File("plugins" + File.separator + "FancyNpcs" + File.separator + "npcs.yml");
        this.isLoaded = false;
    }

    @Override
    public void registerNpc(Npc npc) {
        if (!FancyNpcs.PLAYER_NPCS_FEATURE_FLAG.isEnabled() && this.getAllNpcs().stream().anyMatch(npc1 -> npc1.getData().getName().equals(npc.getData().getName()))) {
            throw new IllegalStateException("An NPC with this name already exists");
        }
        this.npcs.put(npc.getData().getId(), npc);
    }

    @Override
    public void removeNpc(Npc npc) {
        this.npcs.remove(npc.getData().getId());
        YamlConfiguration npcConfig = YamlConfiguration.loadConfiguration((File)this.npcConfigFile);
        npcConfig.set("npcs." + npc.getData().getId(), null);
        try {
            npcConfig.save(this.npcConfigFile);
        }
        catch (IOException e) {
            this.logger.error("Could not save npc config file", ThrowableProperty.of(e));
        }
    }

    @Override
    @ApiStatus.Internal
    public Npc getNpc(int entityId) {
        for (Npc npc : this.getAllNpcs()) {
            if (npc.getEntityId() != entityId) continue;
            return npc;
        }
        return null;
    }

    @Override
    public Npc getNpc(String name) {
        for (Npc npc : this.getAllNpcs()) {
            if (!npc.getData().getName().equalsIgnoreCase(name)) continue;
            return npc;
        }
        return null;
    }

    @Override
    public Npc getNpcById(String id) {
        for (Npc npc : this.getAllNpcs()) {
            if (!npc.getData().getId().equals(id)) continue;
            return npc;
        }
        return null;
    }

    @Override
    public Npc getNpc(String name, UUID creator) {
        for (Npc npc : this.getAllNpcs()) {
            if (!npc.getData().getCreator().equals(creator) || !npc.getData().getName().equalsIgnoreCase(name)) continue;
            return npc;
        }
        return null;
    }

    @Override
    public Collection<Npc> getAllNpcs() {
        return new ArrayList<Npc>(this.npcs.values());
    }

    @Override
    public void saveNpcs(boolean force) {
        if (!this.isLoaded) {
            return;
        }
        if (!this.npcConfigFile.exists()) {
            try {
                this.npcConfigFile.createNewFile();
            }
            catch (IOException e) {
                this.logger.error("Could not create npc config file", ThrowableProperty.of(e));
                return;
            }
        }
        YamlConfiguration npcConfig = YamlConfiguration.loadConfiguration((File)this.npcConfigFile);
        for (Npc npc : this.getAllNpcs()) {
            boolean shouldSave;
            if (!npc.isSaveToFile()) continue;
            boolean bl = shouldSave = force || npc.isDirty();
            if (!shouldSave) continue;
            NpcData data = npc.getData();
            npcConfig.set("npcs." + data.getId() + ".message", null);
            npcConfig.set("npcs." + data.getId() + ".playerCommand", null);
            npcConfig.set("npcs." + data.getId() + ".serverCommand", null);
            npcConfig.set("npcs." + data.getId() + ".mirrorSkin", null);
            npcConfig.set("npcs." + data.getId() + ".skin.value", null);
            npcConfig.set("npcs." + data.getId() + ".skin.signature", null);
            npcConfig.set("npcs." + data.getId() + ".name", (Object)data.getName());
            npcConfig.set("npcs." + data.getId() + ".creator", (Object)data.getCreator().toString());
            npcConfig.set("npcs." + data.getId() + ".displayName", (Object)data.getDisplayName());
            npcConfig.set("npcs." + data.getId() + ".type", (Object)data.getType().name());
            npcConfig.set("npcs." + data.getId() + ".location.world", (Object)data.getLocation().getWorld().getName());
            npcConfig.set("npcs." + data.getId() + ".location.x", (Object)data.getLocation().getX());
            npcConfig.set("npcs." + data.getId() + ".location.y", (Object)data.getLocation().getY());
            npcConfig.set("npcs." + data.getId() + ".location.z", (Object)data.getLocation().getZ());
            npcConfig.set("npcs." + data.getId() + ".location.yaw", (Object)Float.valueOf(data.getLocation().getYaw()));
            npcConfig.set("npcs." + data.getId() + ".location.pitch", (Object)Float.valueOf(data.getLocation().getPitch()));
            npcConfig.set("npcs." + data.getId() + ".showInTab", (Object)data.isShowInTab());
            npcConfig.set("npcs." + data.getId() + ".spawnEntity", (Object)data.isSpawnEntity());
            npcConfig.set("npcs." + data.getId() + ".collidable", (Object)data.isCollidable());
            npcConfig.set("npcs." + data.getId() + ".glowing", (Object)data.isGlowing());
            npcConfig.set("npcs." + data.getId() + ".glowingColor", (Object)data.getGlowingColor().toString());
            npcConfig.set("npcs." + data.getId() + ".turnToPlayer", (Object)data.isTurnToPlayer());
            npcConfig.set("npcs." + data.getId() + ".turnToPlayerDistance", (Object)data.getTurnToPlayerDistance());
            npcConfig.set("npcs." + data.getId() + ".messages", null);
            npcConfig.set("npcs." + data.getId() + ".playerCommands", null);
            npcConfig.set("npcs." + data.getId() + ".serverCommands", null);
            npcConfig.set("npcs." + data.getId() + ".sendMessagesRandomly", null);
            npcConfig.set("npcs." + data.getId() + ".interactionCooldown", (Object)Float.valueOf(data.getInteractionCooldown()));
            npcConfig.set("npcs." + data.getId() + ".scale", (Object)Float.valueOf(data.getScale()));
            npcConfig.set("npcs." + data.getId() + ".visibility_distance", (Object)data.getVisibilityDistance());
            npcConfig.set("npcs." + data.getId() + ".visibility", (Object)data.getVisibility().name());
            if (data.getSkinData() != null) {
                npcConfig.set("npcs." + data.getId() + ".skin.identifier", (Object)data.getSkinData().getIdentifier());
                npcConfig.set("npcs." + data.getId() + ".skin.variant", (Object)data.getSkinData().getVariant().name());
            } else {
                npcConfig.set("npcs." + data.getId() + ".skin.identifier", null);
            }
            npcConfig.set("npcs." + data.getId() + ".skin.mirrorSkin", (Object)data.isMirrorSkin());
            if (data.getEquipment() != null) {
                for (Map.Entry entry : data.getEquipment().entrySet()) {
                    npcConfig.set("npcs." + data.getId() + ".equipment." + ((NpcEquipmentSlot)((Object)entry.getKey())).name(), entry.getValue());
                }
            }
            for (NpcAttribute npcAttribute : FancyNpcs.getInstance().getAttributeManager().getAllAttributesForEntityType(data.getType())) {
                String value = data.getAttributes().getOrDefault(npcAttribute, null);
                npcConfig.set("npcs." + data.getId() + ".attributes." + npcAttribute.getName(), (Object)value);
            }
            npcConfig.set("npcs." + data.getId() + ".actions", null);
            for (Map.Entry entry : npc.getData().getActions().entrySet()) {
                for (NpcAction.NpcActionData actionData : (List)entry.getValue()) {
                    if (actionData == null) continue;
                    npcConfig.set("npcs." + data.getId() + ".actions." + ((ActionTrigger)((Object)entry.getKey())).name() + "." + actionData.order() + ".action", (Object)actionData.action().getName());
                    npcConfig.set("npcs." + data.getId() + ".actions." + ((ActionTrigger)((Object)entry.getKey())).name() + "." + actionData.order() + ".value", (Object)actionData.value());
                }
            }
            npc.setDirty(false);
        }
        try {
            npcConfig.save(this.npcConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadNpcs() {
        this.npcs.clear();
        YamlConfiguration npcConfig = YamlConfiguration.loadConfiguration((File)this.npcConfigFile);
        if (!npcConfig.isConfigurationSection("npcs")) {
            this.setLoaded();
            return;
        }
        for (String id : npcConfig.getConfigurationSection("npcs").getKeys(false)) {
            ConfigurationSection actiontriggerSection;
            boolean oldMirrorSkin;
            String creatorStr;
            String name = npcConfig.getString("npcs." + id + ".name");
            if (name == null) {
                name = id;
            }
            UUID creator = (creatorStr = npcConfig.getString("npcs." + id + ".creator")) == null ? null : UUID.fromString(creatorStr);
            String displayName = npcConfig.getString("npcs." + id + ".displayName", "<empty>");
            EntityType type = EntityType.valueOf((String)npcConfig.getString("npcs." + id + ".type", "PLAYER").toUpperCase());
            Location location = null;
            try {
                location = npcConfig.getLocation("npcs." + id + ".location");
            }
            catch (Exception ignored) {
                this.logger.warn("Could not load location for npc '" + id + "'", new Property[0]);
            }
            if (location == null) {
                String worldName = npcConfig.getString("npcs." + id + ".location.world");
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    World world2 = world = !ServerSoftware.isFolia() ? new WorldCreator(worldName).createWorld() : null;
                }
                if (world == null) {
                    this.logger.info("Could not load npc '" + id + "', because the world '" + worldName + "' is not loaded", new Property[0]);
                    continue;
                }
                double x = npcConfig.getDouble("npcs." + id + ".location.x");
                double y = npcConfig.getDouble("npcs." + id + ".location.y");
                double z = npcConfig.getDouble("npcs." + id + ".location.z");
                float yaw = (float)npcConfig.getDouble("npcs." + id + ".location.yaw");
                float pitch = (float)npcConfig.getDouble("npcs." + id + ".location.pitch");
                location = new Location(world, x, y, z, yaw, pitch);
            }
            SkinData skin = null;
            String skinIdentifier = npcConfig.getString("npcs." + id + ".skin.identifier", npcConfig.getString("npcs." + id + ".skin.uuid", ""));
            String skinVariantStr = npcConfig.getString("npcs." + id + ".skin.variant", SkinData.SkinVariant.AUTO.name());
            SkinData.SkinVariant skinVariant = SkinData.SkinVariant.valueOf(skinVariantStr);
            if (!skinIdentifier.isEmpty()) {
                try {
                    skin = FancyNpcs.getInstance().getSkinManagerImpl().getByIdentifier(skinIdentifier, skinVariant);
                    skin.setIdentifier(skinIdentifier);
                }
                catch (SkinLoadException e) {
                    this.logger.error("NPC named '" + name + "' identified by '" + id + "' could not have their skin loaded.", new Property[0]);
                    this.logger.error("  " + String.valueOf((Object)e.getReason()) + " " + e.getMessage(), new Property[0]);
                }
            }
            if (npcConfig.isSet("npcs." + id + ".skin.value") && npcConfig.isSet("npcs." + id + ".skin.signature")) {
                this.takeBackup(npcConfig);
                String value = npcConfig.getString("npcs." + id + ".skin.value");
                String signature = npcConfig.getString("npcs." + id + ".skin.signature");
                if (value != null && !value.isEmpty() && signature != null && !signature.isEmpty()) {
                    SkinData oldSkin = new SkinData(skinIdentifier, SkinData.SkinVariant.AUTO, value, signature);
                    FancyNpcs.getInstance().getSkinManagerImpl().getFileCache().addSkin(oldSkin);
                    FancyNpcs.getInstance().getSkinManagerImpl().getMemCache().addSkin(oldSkin);
                }
            }
            boolean mirrorSkin = (oldMirrorSkin = npcConfig.getBoolean("npcs." + id + ".mirrorSkin")) || npcConfig.getBoolean("npcs." + id + ".skin.mirrorSkin");
            boolean showInTab = npcConfig.getBoolean("npcs." + id + ".showInTab");
            boolean spawnEntity = npcConfig.getBoolean("npcs." + id + ".spawnEntity");
            boolean collidable = npcConfig.getBoolean("npcs." + id + ".collidable", true);
            boolean glowing = npcConfig.getBoolean("npcs." + id + ".glowing");
            NamedTextColor glowingColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)npcConfig.getString("npcs." + id + ".glowingColor", "white"));
            boolean turnToPlayer = npcConfig.getBoolean("npcs." + id + ".turnToPlayer");
            int turnToPlayerDistance = npcConfig.getInt("npcs." + id + ".turnToPlayerDistance", -1);
            ConcurrentHashMap<ActionTrigger, List<NpcAction.NpcActionData>> actions = new ConcurrentHashMap<ActionTrigger, List<NpcAction.NpcActionData>>();
            boolean sendMessagesRandomly = npcConfig.getBoolean("npcs." + id + ".sendMessagesRandomly", false);
            List playerCommands = npcConfig.getStringList("npcs." + id + ".playerCommands");
            List messages = npcConfig.getStringList("npcs." + id + ".messages");
            List serverCommands = npcConfig.getStringList("npcs." + id + ".serverCommands");
            ArrayList<NpcAction.NpcActionData> migrateActionList = new ArrayList<NpcAction.NpcActionData>();
            int actionOrder = 0;
            for (String playerCommand : playerCommands) {
                migrateActionList.add(new NpcAction.NpcActionData(++actionOrder, FancyNpcs.getInstance().getActionManager().getActionByName("player_command"), playerCommand));
            }
            for (String serverCommand : serverCommands) {
                migrateActionList.add(new NpcAction.NpcActionData(++actionOrder, FancyNpcs.getInstance().getActionManager().getActionByName("console_command"), serverCommand));
            }
            if (sendMessagesRandomly && !messages.isEmpty()) {
                migrateActionList.add(new NpcAction.NpcActionData(++actionOrder, FancyNpcs.getInstance().getActionManager().getActionByName("execute_random_action"), ""));
            }
            for (String message : messages) {
                migrateActionList.add(new NpcAction.NpcActionData(++actionOrder, FancyNpcs.getInstance().getActionManager().getActionByName("message"), message));
            }
            if (!migrateActionList.isEmpty()) {
                this.takeBackup(npcConfig);
                actions.put(ActionTrigger.ANY_CLICK, migrateActionList);
            }
            if ((actiontriggerSection = npcConfig.getConfigurationSection("npcs." + id + ".actions")) != null) {
                actiontriggerSection.getKeys(false).forEach(trigger -> {
                    ActionTrigger actionTrigger = ActionTrigger.getByName(trigger);
                    if (actionTrigger == null) {
                        this.logger.warn("Could not find action trigger: " + trigger, new Property[0]);
                        return;
                    }
                    ArrayList actionList = new ArrayList();
                    ConfigurationSection actionsSection = npcConfig.getConfigurationSection("npcs." + id + ".actions." + trigger);
                    if (actionsSection != null) {
                        actionsSection.getKeys(false).forEach(order -> {
                            String actionName = npcConfig.getString("npcs." + id + ".actions." + trigger + "." + order + ".action");
                            String value = npcConfig.getString("npcs." + id + ".actions." + trigger + "." + order + ".value");
                            NpcAction action = FancyNpcs.getInstance().getActionManager().getActionByName(actionName);
                            if (action == null) {
                                this.logger.warn("Could not find action: " + actionName, new Property[0]);
                                return;
                            }
                            try {
                                actionList.add(new NpcAction.NpcActionData(Integer.parseInt(order), action, value));
                            }
                            catch (NumberFormatException e) {
                                this.logger.warn("Could not parse order: " + order, new Property[0]);
                            }
                        });
                        actions.put(actionTrigger, actionList);
                    }
                });
            }
            float interactionCooldown = (float)npcConfig.getDouble("npcs." + id + ".interactionCooldown", 0.0);
            float scale = (float)npcConfig.getDouble("npcs." + id + ".scale", 1.0);
            int visibilityDistance = npcConfig.getInt("npcs." + id + ".visibility_distance", -1);
            String visibilityStr = npcConfig.getString("npcs." + id + ".visibility", "ALL");
            NpcVisibility visibility = NpcVisibility.byString(visibilityStr).orElse(NpcVisibility.ALL);
            HashMap<NpcAttribute, String> attributes = new HashMap<NpcAttribute, String>();
            if (npcConfig.isConfigurationSection("npcs." + id + ".attributes")) {
                for (String attrName : npcConfig.getConfigurationSection("npcs." + id + ".attributes").getKeys(false)) {
                    NpcAttribute attribute = FancyNpcs.getInstance().getAttributeManager().getAttributeByName(type, attrName);
                    if (attribute == null) {
                        this.logger.warn("Could not find attribute: " + attrName, new Property[0]);
                        continue;
                    }
                    String value = npcConfig.getString("npcs." + id + ".attributes." + attrName);
                    if (!attribute.isValidValue(value)) {
                        this.logger.warn("Invalid value for attribute: " + attrName, new Property[0]);
                        continue;
                    }
                    attributes.put(attribute, value);
                }
            }
            NpcData data = new NpcData(id, name, creator, displayName, skin, location, showInTab, spawnEntity, collidable, glowing, glowingColor, type, new HashMap<NpcEquipmentSlot, ItemStack>(), turnToPlayer, turnToPlayerDistance, null, actions, interactionCooldown, scale, visibilityDistance, attributes, mirrorSkin);
            Npc npc = this.npcAdapter.apply(data);
            if (npcConfig.isConfigurationSection("npcs." + id + ".equipment")) {
                for (String equipmentSlotStr : npcConfig.getConfigurationSection("npcs." + id + ".equipment").getKeys(false)) {
                    NpcEquipmentSlot equipmentSlot = NpcEquipmentSlot.parse(equipmentSlotStr);
                    ItemStack item = npcConfig.getItemStack("npcs." + id + ".equipment." + equipmentSlotStr);
                    npc.getData().addEquipment(equipmentSlot, item);
                }
            }
            npc.getData().setVisibility(visibility);
            npc.create();
            this.registerNpc(npc);
        }
        this.setLoaded();
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    private void setLoaded() {
        this.isLoaded = true;
        new NpcsLoadedEvent().callEvent();
    }

    @Override
    public void reloadNpcs() {
        ArrayList<Npc> npcCopy = new ArrayList<Npc>(this.getAllNpcs());
        this.npcs.clear();
        for (Npc npc : npcCopy) {
            npc.removeForAll();
        }
        this.loadNpcs();
    }

    private void takeBackup(YamlConfiguration npcConfig) {
        String folderPath = "plugins" + File.separator + "FancyNpcs" + File.separator + "/backups";
        File backupDir = new File(folderPath);
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String backupFileName = "npcs-" + formatter.format(now) + ".yml";
        File backupFile = new File(folderPath + File.separator + backupFileName);
        if (backupFile.exists()) {
            backupFile.delete();
        }
        try {
            backupFile.createNewFile();
        }
        catch (IOException e) {
            this.logger.error("Could not create backup file for NPCs", new Property[0]);
        }
        try {
            npcConfig.save(backupFile);
        }
        catch (IOException e) {
            this.logger.error("Could not save backup file for NPCs", new Property[0]);
        }
    }
}

