/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.actions.ActionTrigger;
import de.oliver.fancynpcs.api.actions.NpcAction;
import de.oliver.fancynpcs.api.events.NpcCreateEvent;
import de.oliver.fancynpcs.api.utils.NpcEquipmentSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public enum CopyCMD {
    INSTANCE;

    private static final Pattern NPC_NAME_PATTERN;
    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    @Command(value="npc copy <npc> <name>", requiredSender=Player.class)
    @Permission(value={"fancynpcs.command.npc.copy"})
    public void onCopy(@NotNull Player sender, @NotNull Npc npc, @NotNull String name) {
        if (!NPC_NAME_PATTERN.matcher(name).find()) {
            this.translator.translate("npc_create_failure_invalid_name").replaceStripped("name", name).send((CommandSender)sender);
            return;
        }
        Npc copied = FancyNpcs.getInstance().getNpcAdapter().apply(new NpcData(UUID.randomUUID().toString(), name, sender.getUniqueId(), npc.getData().getDisplayName(), npc.getData().getSkinData(), sender.getLocation().clone(), npc.getData().isShowInTab(), npc.getData().isSpawnEntity(), npc.getData().isCollidable(), npc.getData().isGlowing(), npc.getData().getGlowingColor(), npc.getData().getType(), new ConcurrentHashMap<NpcEquipmentSlot, ItemStack>(npc.getData().getEquipment()), npc.getData().isTurnToPlayer(), npc.getData().getTurnToPlayerDistance(), npc.getData().getOnClick(), (Map<ActionTrigger, List<NpcAction.NpcActionData>>)npc.getData().getActions().entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()))), npc.getData().getInteractionCooldown(), npc.getData().getScale(), npc.getData().getVisibilityDistance(), new ConcurrentHashMap<NpcAttribute, String>(npc.getData().getAttributes()), npc.getData().isMirrorSkin()));
        if (new NpcCreateEvent(copied, (CommandSender)sender).callEvent()) {
            copied.create();
            FancyNpcs.getInstance().getNpcManagerImpl().registerNpc(copied);
            copied.spawnForAll();
            this.translator.translate("npc_copy_success").replace("npc", npc.getData().getName()).replace("new_npc", copied.getData().getName()).send((CommandSender)sender);
        } else {
            this.translator.translate("command_npc_modification_cancelled").send((CommandSender)sender);
        }
    }

    static {
        NPC_NAME_PATTERN = Pattern.compile("^[A-Za-z0-9/_-]*$");
    }
}

