/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.tracker;

import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.events.NpcStartLookingEvent;
import de.oliver.fancynpcs.api.events.NpcStopLookingEvent;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TurnToPlayerTracker
implements Runnable {
    @Override
    public void run() {
        Collection<Npc> npcs = FancyNpcs.getInstance().getNpcManagerImpl().getAllNpcs();
        int defaultTurnToPlayerDistance = FancyNpcs.getInstance().getFancyNpcConfig().getTurnToPlayerDistance();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location playerLocation = player.getLocation();
            for (Npc npc : npcs) {
                int effectiveTurnDistance;
                double distance;
                NpcData npcData = npc.getData();
                Location npcLocation = npcData.getLocation();
                if (npcLocation == null || !npcLocation.getWorld().getName().equalsIgnoreCase(playerLocation.getWorld().getName()) || Double.isNaN(distance = playerLocation.distance(npcLocation))) continue;
                int npcTurnDistance = npcData.getTurnToPlayerDistance();
                int n = effectiveTurnDistance = npcTurnDistance == -1 ? defaultTurnToPlayerDistance : npcTurnDistance;
                if (npcData.isTurnToPlayer() && distance < (double)effectiveTurnDistance) {
                    double baseEyeHeight = this.getEntityEyeHeight(npcData.getType());
                    Location adjustedNpcLocation = npcLocation.clone();
                    adjustedNpcLocation.setY(npcLocation.getY() + baseEyeHeight * (double)npcData.getScale());
                    Location playerEyeLocation = playerLocation.clone();
                    playerEyeLocation.setY(playerLocation.getY() + player.getEyeHeight());
                    Location newLoc = playerEyeLocation.clone();
                    newLoc.setDirection(newLoc.subtract(adjustedNpcLocation).toVector());
                    npc.lookAt(player, newLoc);
                    Boolean wasPreviouslyLooking = npc.getIsLookingAtPlayer().put(player.getUniqueId(), true);
                    if (wasPreviouslyLooking != null && wasPreviouslyLooking.booleanValue()) continue;
                    FancyNpcs.getInstance().getScheduler().runTask(null, () -> Bukkit.getPluginManager().callEvent((Event)new NpcStartLookingEvent(npc, player)));
                    continue;
                }
                if (!npcData.isTurnToPlayer() || !npc.getIsLookingAtPlayer().getOrDefault(player.getUniqueId(), false).booleanValue()) continue;
                npc.getIsLookingAtPlayer().put(player.getUniqueId(), false);
                if (FancyNpcs.getInstance().getFancyNpcConfig().isTurnToPlayerResetToInitialDirection()) {
                    npc.move(player, false);
                }
                FancyNpcs.getInstance().getScheduler().runTask(null, () -> Bukkit.getPluginManager().callEvent((Event)new NpcStopLookingEvent(npc, player)));
            }
        }
    }

    private double getEntityEyeHeight(EntityType type) {
        return switch (type) {
            case EntityType.PLAYER -> 1.62;
            case EntityType.ZOMBIE, EntityType.SKELETON, EntityType.STRAY, EntityType.HUSK, EntityType.DROWNED, EntityType.WITHER_SKELETON -> 1.74;
            case EntityType.CREEPER -> 1.7;
            case EntityType.ENDERMAN -> 2.55;
            case EntityType.SPIDER, EntityType.CAVE_SPIDER -> 0.5;
            case EntityType.PIG -> 0.6;
            case EntityType.SHEEP -> 0.65;
            case EntityType.COW, EntityType.MOOSHROOM -> 1.3;
            case EntityType.CHICKEN -> 0.4;
            case EntityType.HORSE, EntityType.DONKEY, EntityType.MULE -> 1.52;
            case EntityType.VILLAGER, EntityType.ZOMBIE_VILLAGER -> 1.62;
            case EntityType.IRON_GOLEM -> 2.7;
            case EntityType.WOLF -> 0.68;
            case EntityType.CAT, EntityType.OCELOT -> 0.35;
            case EntityType.RABBIT -> 0.3;
            case EntityType.BAT -> 0.45;
            case EntityType.SQUID, EntityType.GLOW_SQUID -> 0.4;
            case EntityType.SILVERFISH -> 0.13;
            case EntityType.ENDERMITE -> 0.13;
            case EntityType.BLAZE -> 1.7;
            case EntityType.GHAST -> 2.0;
            case EntityType.SLIME, EntityType.MAGMA_CUBE -> 0.5;
            case EntityType.WITCH -> 1.62;
            case EntityType.EVOKER, EntityType.VINDICATOR, EntityType.ILLUSIONER, EntityType.PILLAGER -> 1.62;
            case EntityType.VEX -> 0.8;
            case EntityType.GUARDIAN, EntityType.ELDER_GUARDIAN -> 0.425;
            case EntityType.SHULKER -> 0.5;
            case EntityType.PHANTOM -> 0.5;
            case EntityType.BEE -> 0.3;
            case EntityType.FOX -> 0.4;
            case EntityType.PANDA -> 1.13;
            case EntityType.STRIDER -> 1.7;
            case EntityType.HOGLIN, EntityType.ZOGLIN -> 1.4;
            case EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.ZOMBIFIED_PIGLIN -> 1.62;
            case EntityType.AXOLOTL -> 0.3;
            case EntityType.GOAT -> 0.9;
            case EntityType.ALLAY -> 0.6;
            case EntityType.FROG -> 0.25;
            case EntityType.TADPOLE -> 0.13;
            case EntityType.WARDEN -> 2.5;
            case EntityType.CAMEL -> 2.275;
            case EntityType.SNIFFER -> 1.0;
            case EntityType.BREEZE -> 1.4;
            case EntityType.ARMADILLO -> 0.26;
            case EntityType.BOGGED -> 1.74;
            case EntityType.ARMOR_STAND -> 1.975;
            case EntityType.TEXT_DISPLAY, EntityType.ITEM_DISPLAY, EntityType.BLOCK_DISPLAY, EntityType.INTERACTION -> 0.5;
            default -> 1.62;
        };
    }
}

