/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v1_21_11.packets;

import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.packets.FS_ClientboundSetEntityDataPacket;
import de.oliver.fancysitula.api.utils.reflections.ReflectionUtils;
import de.oliver.fancysitula.versions.v1_21_11.utils.VanillaPlayerAdapter;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.inventory.ItemStack;

public class ClientboundSetEntityDataPacketImpl
extends FS_ClientboundSetEntityDataPacket {
    private static final ConcurrentMap<String, Class<?>> ENTITY_CLASS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<String, EntityDataAccessor<Object>> ENTITY_ACCESSOR_CACHE = new ConcurrentHashMap<String, EntityDataAccessor<Object>>();

    public ClientboundSetEntityDataPacketImpl(int entityId, List<FS_ClientboundSetEntityDataPacket.EntityData> entityData) {
        super(entityId, entityData);
    }

    private static Class<?> getEntityClassCached(String className) throws ClassNotFoundException {
        Class cached = (Class)ENTITY_CLASS_CACHE.get(className);
        if (cached != null) {
            return cached;
        }
        Class<?> resolved = Class.forName(className);
        ENTITY_CLASS_CACHE.put(className, resolved);
        return resolved;
    }

    private static EntityDataAccessor<Object> getAccessorCached(String entityClassName, String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String key = entityClassName + "#" + fieldName;
        EntityDataAccessor cached = (EntityDataAccessor)ENTITY_ACCESSOR_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        Class<?> entityClass = ClientboundSetEntityDataPacketImpl.getEntityClassCached(entityClassName);
        EntityDataAccessor accessor = (EntityDataAccessor)ReflectionUtils.getStaticField(entityClass, fieldName);
        ENTITY_ACCESSOR_CACHE.put(key, (EntityDataAccessor<Object>)accessor);
        return accessor;
    }

    @Override
    public Object createPacket() {
        ArrayList<SynchedEntityData.DataValue> dataValues = new ArrayList<SynchedEntityData.DataValue>();
        for (FS_ClientboundSetEntityDataPacket.EntityData data : this.entityData) {
            try {
                String entityClassName = data.getAccessor().entityClassName();
                String accessorFieldName = data.getAccessor().accessorFieldName();
                EntityDataAccessor<Object> accessor = ClientboundSetEntityDataPacketImpl.getAccessorCached(entityClassName, accessorFieldName);
                Object vanillaValue = data.getValue();
                if (data.getValue() == null) continue;
                Object object = data.getValue();
                if (object instanceof Component) {
                    Component c = (Component)object;
                    vanillaValue = PaperAdventure.asVanilla((Component)c);
                }
                if ((object = data.getValue()) instanceof ItemStack) {
                    ItemStack i = (ItemStack)object;
                    vanillaValue = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)i);
                }
                if ((object = data.getValue()) instanceof BlockState) {
                    BlockState b2 = (BlockState)object;
                    vanillaValue = ((CraftBlockState)b2).getHandle();
                }
                dataValues.add(SynchedEntityData.DataValue.create(accessor, (Object)vanillaValue));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return new ClientboundSetEntityDataPacket(this.entityId, dataValues);
    }

    @Override
    public void sendPacketTo(FS_RealPlayer player) {
        ClientboundSetEntityDataPacket packet = (ClientboundSetEntityDataPacket)this.createPacket();
        ServerPlayer vanillaPlayer = VanillaPlayerAdapter.asVanilla(player.getBukkitPlayer());
        vanillaPlayer.connection.send((Packet)packet);
    }
}

