/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.armorstandeditor;

import com.mojang.authlib.GameProfile;
import eu.pb4.armorstandeditor.CardboardWarning;
import eu.pb4.armorstandeditor.EditorActions;
import eu.pb4.armorstandeditor.GenericModInfo;
import eu.pb4.armorstandeditor.config.Config;
import eu.pb4.armorstandeditor.config.ConfigManager;
import eu.pb4.armorstandeditor.config.PlayerData;
import eu.pb4.armorstandeditor.gui.EditingContext;
import eu.pb4.armorstandeditor.gui.ItemFrameEditorGui;
import eu.pb4.armorstandeditor.gui.MainGui;
import eu.pb4.armorstandeditor.util.GeneralCommands;
import eu.pb4.armorstandeditor.util.TextUtils;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.sgui.api.GuiHelpers;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.disguiselib.api.EntityDisguise;

public class ArmorStandEditorMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Armor Stand Editor");
    public static String VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("armor-stand-editor").get()).getMetadata().getVersion().getFriendlyString();

    public void onInitialize() {
        GenericModInfo.build((ModContainer)FabricLoader.getInstance().getModContainer("armor-stand-editor").get());
        PlayerDataApi.register(PlayerData.STORAGE);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ConfigManager.loadConfig());
        ServerLifecycleEvents.SERVER_STARTED.register(s -> CardboardWarning.checkAndAnnounce());
        GeneralCommands.register();
        boolean checkDisguise = FabricLoader.getInstance().isModLoaded("disguiselib");
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (world.method_8608()) {
                return class_1269.field_5811;
            }
            class_1799 itemStack = player.method_6047();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (entity instanceof class_1533) {
                    class_1533 frameEntity = (class_1533)entity;
                    if (ArmorStandEditorMod.hasCorrectToolAndPermsItemFrame(serverPlayer, itemStack, entity)) {
                        new ItemFrameEditorGui(serverPlayer, frameEntity);
                        return class_1269.field_5812;
                    }
                }
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_3222 serverPlayer;
            if (world.method_8608()) {
                return class_1269.field_5811;
            }
            class_1799 itemStack = player.method_5998(hand);
            if (player instanceof class_3222 && ArmorStandEditorMod.hasCorrectToolAndPerms(serverPlayer = (class_3222)player, itemStack, entity)) {
                EntityDisguise disguise;
                if (checkDisguise && entity instanceof EntityDisguise && (disguise = (EntityDisguise)entity).isDisguised()) {
                    entity = disguise.getDisguiseEntity();
                }
                if (entity instanceof class_1531) {
                    class_1531 armorStandEntity = (class_1531)entity;
                    new MainGui(new EditingContext(serverPlayer, armorStandEntity), 0);
                    player.method_7353((class_2561)TextUtils.text("open_info", class_2561.method_43472((String)"key.drop")), true);
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
    }

    public static boolean hasCorrectToolAndPerms(class_3222 player, class_1799 itemStack, @Nullable class_1297 entity) {
        class_1531 armorStandEntity;
        Config config = ConfigManager.getConfig();
        return !(GuiHelpers.getCurrentGui((class_3222)player) != null || !EditorActions.OPEN_EDITOR.canUse((class_1657)player) || player.method_7325() || itemStack.method_7909() != config.armorStandTool || config.configData.requireNbtTagForEditor && !((class_9279)itemStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_68566("isArmorStandEditor", false) || entity instanceof class_1531 && (armorStandEntity = (class_1531)entity).method_6912() || entity != null && !CommonProtection.canInteractEntity((class_1937)entity.method_73183(), (class_1297)entity, (GameProfile)player.method_7334(), (class_1657)player));
    }

    public static boolean hasCorrectToolAndPermsItemFrame(class_3222 player, class_1799 itemStack, @Nullable class_1297 entity) {
        Config config = ConfigManager.getConfig();
        return !(GuiHelpers.getCurrentGui((class_3222)player) != null || !EditorActions.OPEN_ITEM_FRAME_EDITOR.canUse((class_1657)player) || player.method_7325() || itemStack.method_7909() != config.armorStandTool || config.configData.requireNbtTagForEditor && !((class_9279)itemStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_68566("isArmorStandEditor", false) || entity != null && !CommonProtection.canInteractEntity((class_1937)entity.method_73183(), (class_1297)entity, (GameProfile)player.method_7334(), (class_1657)player));
    }
}

