/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.armorstandeditor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.armorstandeditor.ArmorStandEditorMod;
import eu.pb4.armorstandeditor.config.ArmorStandPreset;
import eu.pb4.armorstandeditor.config.Config;
import eu.pb4.armorstandeditor.config.ConfigData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class ConfigManager {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final HashMap<String, ArmorStandPreset> PRESETS = new HashMap();
    public static final Pattern INVALID_CHAR = Pattern.compile("[^a-z0-9_]");
    private static Config CONFIG;

    public static Config getConfig() {
        return CONFIG;
    }

    public static boolean loadConfig() {
        boolean success;
        Config oldConfig = CONFIG;
        CONFIG = null;
        try {
            File configDir = Paths.get("", "config", "armor-stand-editor").toFile();
            File presetsDir = Paths.get("", "config", "armor-stand-editor", "presets").toFile();
            presetsDir.mkdirs();
            File configFile = new File(configDir, "config.json");
            ConfigData configData = configFile.exists() ? (ConfigData)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8"), ConfigData.class) : new ConfigData();
            configData.update();
            CONFIG = new Config(configData);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "UTF-8"));
            writer.write(GSON.toJson((Object)configData));
            writer.close();
            PRESETS.clear();
            Optional containerOptional = FabricLoader.getInstance().getModContainer("armor-stand-editor");
            if (containerOptional.isPresent()) {
                ModContainer container = (ModContainer)containerOptional.get();
                Path buildInPresets = container.getPath("presets");
                Files.walkFileTree(buildInPresets, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        ArmorStandPreset preset = (ArmorStandPreset)GSON.fromJson((Reader)new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), "UTF-8"), ArmorStandPreset.class);
                        if (!(ConfigManager.CONFIG.configData.blockedBuiltinPresets.contains(preset.id) || ConfigManager.CONFIG.configData.blockedBuiltinPresets.contains(preset.id.substring(1)) || ConfigManager.CONFIG.configData.blockedBuiltinPresets.contains("buildin/" + preset.id.substring(1)))) {
                            PRESETS.put(preset.id, preset);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                ArmorStandEditorMod.LOGGER.error("Something went really badly while getting buildin presets. Did someone change modid? :irritater:");
            }
            for (String name2 : presetsDir.list((file, name) -> name.endsWith(".json"))) {
                File file2 = new File(presetsDir, name2);
                ArmorStandPreset preset = (ArmorStandPreset)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"), ArmorStandPreset.class);
                String tmp = name2.substring(0, name2.length() - 5);
                file2.delete();
                preset.id = tmp.replaceAll(INVALID_CHAR.pattern(), "_");
                PRESETS.put(preset.id, preset);
                BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                writer2.write(GSON.toJson((Object)preset));
                writer2.close();
            }
            success = true;
        }
        catch (IOException exception) {
            success = false;
            CONFIG = oldConfig;
            ArmorStandEditorMod.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return success;
    }

    public static boolean savePreset(ArmorStandPreset preset) {
        try {
            File presetsDir = Paths.get("", "config", "armor-stand-editor", "presets").toFile();
            presetsDir.mkdirs();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(presetsDir, preset.id + ".json")), "UTF-8"));
            writer.write(GSON.toJson((Object)preset));
            writer.close();
            PRESETS.put(preset.id, preset);
            return true;
        }
        catch (Exception e) {
            ArmorStandEditorMod.LOGGER.error("Couldn't save preset " + preset.id);
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deletePreset(String id) {
        try {
            File preset = Paths.get("", "config", "armor-stand-editor", "presets", id + ".json").toFile();
            if (id.startsWith("$")) {
                return false;
            }
            PRESETS.remove(id);
            if (preset.exists()) {
                preset.delete();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

