/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.armorstandeditor.gui;

import eu.pb4.armorstandeditor.EditorActions;
import eu.pb4.armorstandeditor.gui.EditingContext;
import eu.pb4.armorstandeditor.util.TextUtils;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public abstract class BaseChestGui
extends SimpleGui {
    protected EditingContext context;

    public BaseChestGui(EditingContext context, class_3917 type, boolean withPlayerSlots) {
        super(type, context.player, withPlayerSlots);
        this.context = context;
    }

    public void onTick() {
        this.checkClosed();
        super.onTick();
    }

    private void checkClosed() {
        if (this.context.checkClosed()) {
            this.close();
        }
    }

    protected void rebuildUi() {
        for (int i = 0; i < this.size; ++i) {
            this.clearSlot(i);
        }
        this.buildUi();
    }

    protected GuiElementBuilder closeButton() {
        return new GuiElementBuilder().model(class_1802.field_8077).setName((class_2561)TextUtils.gui(this.context.interfaceList.isEmpty() ? "close" : "back", new Object[0])).setRarity(class_1814.field_8906).hideDefaultTooltip().setCallback((x, y, z, c) -> {
            this.playClickSound();
            this.openPreviousOrClose();
        });
    }

    protected void openPreviousOrClose() {
        if (this.context == null || this.context.interfaceList.isEmpty()) {
            this.close();
        } else {
            this.switchUi(this.context.interfaceList.removeFirst(), false);
        }
    }

    protected void playClickSound() {
        this.playSound((class_6880<class_3414>)class_3417.field_15015, 0.5f, 1.0f);
    }

    public boolean onClick(int index, ClickType type, class_1713 action, GuiElementInterface element) {
        if (type == ClickType.DROP || type == ClickType.CTRL_DROP) {
            this.close();
            return true;
        }
        return super.onClick(index, type, action, element);
    }

    protected void addSlot(EditorActions actions, GuiElementBuilder builder) {
        if (actions.canUse((class_1657)this.player)) {
            this.addSlot((GuiElementBuilderInterface)builder);
        }
    }

    protected void setSlot(int slot, EditorActions actions, GuiElementBuilder builder) {
        if (actions.canUse((class_1657)this.player)) {
            this.addSlot((GuiElementBuilderInterface)builder);
        }
    }

    protected abstract void buildUi();

    protected abstract EditingContext.SwitchEntry asSwitchableUi();

    protected GuiElementBuilder baseElement(class_1792 item, String name, boolean selected) {
        GuiElementBuilder builder = new GuiElementBuilder().model(item).setName((class_2561)TextUtils.gui(name, new Object[0]).method_27692(class_124.field_1068)).hideDefaultTooltip();
        if (selected) {
            builder.glow();
        }
        return builder;
    }

    protected GuiElementBuilder baseElement(class_1792 item, class_5250 text, boolean selected) {
        GuiElementBuilder builder = new GuiElementBuilder().model(item).setName((class_2561)text.method_27692(class_124.field_1068)).hideDefaultTooltip();
        if (selected) {
            builder.glow();
        }
        return builder;
    }

    protected GuiElementBuilder switchElement(class_1792 item, String name, EditingContext.SwitchableUi ui) {
        return new GuiElementBuilder().model(item).setName((class_2561)TextUtils.gui("entry." + name, new Object[0]).method_27692(class_124.field_1068)).hideDefaultTooltip().setCallback(this.switchCallback(ui));
    }

    protected GuiElementInterface.ClickCallback switchCallback(EditingContext.SwitchableUi ui) {
        return (x, y, z, c) -> {
            this.playSound((class_6880<class_3414>)class_3417.field_15015, 0.5f, 1.0f);
            this.switchUi(new EditingContext.SwitchEntry(ui, 0), true);
        };
    }

    public void switchUi(EditingContext.SwitchEntry uiOpener, boolean addSelf) {
        if (uiOpener.currentSlot() == -1) {
            this.close(false);
        }
        EditingContext context = this.context;
        if (addSelf) {
            context.interfaceList.addFirst(this.asSwitchableUi());
        }
        this.context = null;
        uiOpener.open(context);
    }

    public void onClose() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected void playSound(class_6880<class_3414> sound, float volume, float pitch) {
        this.player.field_13987.method_14364((class_2596)new class_2767(sound, class_3419.field_15250, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), volume, pitch, 0L));
    }
}

