/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.armorstandeditor.gui;

import com.mojang.authlib.GameProfile;
import eu.pb4.armorstandeditor.gui.BaseWorldGui;
import eu.pb4.armorstandeditor.gui.EditingContext;
import eu.pb4.armorstandeditor.util.TextUtils;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2735;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_6880;

public class MoveGui
extends BaseWorldGui {
    private CurrentAxis currentAxis = CurrentAxis.LOOK;
    private class_2350 playerLookingDirection;

    public MoveGui(EditingContext context, int slot) {
        super(context, slot);
        class_243 vec = this.player.method_5828(0.0f);
        this.playerLookingDirection = class_2350.method_10142((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
        this.rebuildUi();
        this.open();
    }

    @Override
    public void onTick() {
        if (this.currentAxis.axis == null) {
            class_243 vec = this.player.method_5828(0.0f);
            class_2350 dir = class_2350.method_10142((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
            if (dir != this.playerLookingDirection) {
                this.playerLookingDirection = dir;
                this.rebuildUi();
            }
        }
        super.onTick();
    }

    @Override
    protected void buildUi() {
        class_1792 wool = switch (this.currentAxis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_1802.field_19044;
            case 1 -> class_1802.field_19058;
            case 2 -> class_1802.field_19057;
            case 3 -> class_1802.field_19055;
        };
        double moveBase = (double)((int)(this.context.moveBlockDelta * 100.0)) / 100.0;
        this.setSlot(0, (GuiElementBuilderInterface)this.baseElement(wool, TextUtils.gui("action.move." + this.currentAxis.name().toLowerCase(Locale.ROOT), TextUtils.direction(this.getDirection(true))), false).setCallback((x, y, z, c) -> {
            if (this.player.method_5715()) {
                return;
            }
            this.playClickSound();
            this.currentAxis = CurrentAxis.values()[(this.currentAxis.ordinal() + CurrentAxis.values().length + (y.isRight ? 1 : (y.isLeft ? -1 : 0))) % CurrentAxis.values().length];
            this.buildUi();
        }));
        this.setSlot(1, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8675, TextUtils.gui("action.move", moveBase * 0.5, TextUtils.direction(this.getDirection(false))), false).setCallback((x, y, z, c) -> this.move(-moveBase * 0.5)));
        this.setSlot(2, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8620, TextUtils.gui("action.move", moveBase, TextUtils.direction(this.getDirection(false))), false).setCallback((x, y, z, c) -> this.move(-moveBase)));
        this.setSlot(3, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8251, TextUtils.gui("action.move.rotate", this.context.moveRotationDelta), false).setCallback((x, y, z, c) -> {
            if (this.player.method_5715()) {
                return;
            }
            class_243 pos = this.context.armorStand.method_73189();
            this.context.armorStand.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, this.context.armorStand.method_36454() + (float)(this.context.moveRotationDelta * (y.isRight ? -1 : (y.isLeft ? 1 : 0))), 0.0f);
        }));
        this.setSlot(4, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8695, TextUtils.gui("action.move", moveBase, TextUtils.direction(this.getDirection(true))), false).setCallback((x, y, z, c) -> this.move(moveBase)));
        this.setSlot(5, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8397, TextUtils.gui("action.move", moveBase * 0.5, TextUtils.direction(this.getDirection(true))), false).setCallback((x, y, z, c) -> this.move(moveBase * 0.5)));
        this.setSlot(6, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8634, TextUtils.gui("action.move.teleport", new Object[0]), false).setCallback((x, y, z, c) -> {
            if (this.player.method_5715()) {
                return;
            }
            this.playClickSound();
            this.context.armorStand.method_33574(this.player.method_73189());
        }));
        this.setSlot(7, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8107, TextUtils.gui("action.move.rotate.copy_player", new Object[0]), false).setCallback((x, y, z, c) -> {
            if (this.player.method_5715()) {
                return;
            }
            this.playClickSound();
            class_243 pos = this.context.armorStand.method_73189();
            this.context.armorStand.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, this.player.method_36454(), 0.0f);
        }));
    }

    private class_2350 getDirection(boolean positive) {
        if (this.currentAxis.axis == null) {
            return positive ? this.playerLookingDirection : this.playerLookingDirection.method_10153();
        }
        return class_2350.method_10169((class_2350.class_2351)this.currentAxis.axis, (class_2350.class_2352)(positive ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060));
    }

    public boolean onSelectedSlotChange(int slot) {
        if (this.player.method_5715()) {
            int current = this.getSelectedSlot();
            int delta = slot - current;
            if (current == 3) {
                this.context.moveRotationDelta = class_3532.method_15340((int)(this.context.moveRotationDelta + delta), (int)0, (int)360);
                this.player.method_7353((class_2561)TextUtils.gui("action.move.rotate.set", this.context.moveRotationDelta), true);
            } else {
                double value = this.context.moveBlockDelta == 0.1 && delta < 0 || this.context.moveBlockDelta < 0.1 ? (double)((int)(this.context.moveBlockDelta * 100.0 + (double)delta)) / 100.0 : (double)((int)(this.context.moveBlockDelta * 10.0 + (double)delta)) / 10.0;
                this.context.moveBlockDelta = class_3532.method_15350((double)value, (double)0.0, (double)5.0);
                this.player.method_7353((class_2561)TextUtils.gui("action.move.set", this.context.moveBlockDelta), true);
            }
            this.playSound((class_6880<class_3414>)class_3417.field_15204, 0.5f, 1.0f);
            this.player.field_13987.method_14364((class_2596)new class_2735(this.selectedSlot));
            this.buildUi();
            return false;
        }
        return super.onSelectedSlotChange(slot);
    }

    private void move(double v) {
        if (this.player.method_5715()) {
            return;
        }
        class_243 pos = this.context.armorStand.method_73189();
        if (this.currentAxis.axis != null) {
            this.context.armorStand.method_5814(pos.field_1352 + this.currentAxis.axis.method_10172(v, 0.0, 0.0), pos.field_1351 + this.currentAxis.axis.method_10172(0.0, v, 0.0), pos.field_1350 + this.currentAxis.axis.method_10172(0.0, 0.0, v));
        } else {
            this.context.armorStand.method_5814(pos.field_1352 + (double)this.playerLookingDirection.method_10148() * v, pos.field_1351 + (double)this.playerLookingDirection.method_10164() * v, pos.field_1350 + (double)this.playerLookingDirection.method_10165() * v);
        }
        if (!CommonProtection.canInteractEntity((class_1937)this.context.player.method_51469(), (class_1297)this.context.armorStand, (GameProfile)this.context.player.method_7334(), (class_1657)this.context.player)) {
            this.context.armorStand.method_33574(pos);
        }
    }

    @Override
    protected EditingContext.SwitchEntry asSwitchableUi() {
        return new EditingContext.SwitchEntry(MoveGui::new, this.getSelectedSlot());
    }

    static enum CurrentAxis {
        LOOK(null),
        X(class_2350.class_2351.field_11048),
        Y(class_2350.class_2351.field_11052),
        Z(class_2350.class_2351.field_11051);

        private final class_2350.class_2351 axis;

        private CurrentAxis(class_2350.class_2351 axis) {
            this.axis = axis;
        }
    }
}

