/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.armorstandeditor.gui;

import eu.pb4.armorstandeditor.config.ArmorStandPreset;
import eu.pb4.armorstandeditor.config.ConfigManager;
import eu.pb4.armorstandeditor.config.PlayerData;
import eu.pb4.armorstandeditor.gui.BaseChestGui;
import eu.pb4.armorstandeditor.gui.EditingContext;
import eu.pb4.armorstandeditor.util.PlayerExt;
import eu.pb4.armorstandeditor.util.TextUtils;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3917;

public class PresetSelectorGui
extends BaseChestGui {
    private final ArrayList<ArmorStandPreset> presets;
    private final Supplier<Collection<ArmorStandPreset>> presetSupplier;
    private final Consumer<ArmorStandPreset> remover;
    private int page = 0;

    public static void globalPresets(EditingContext context, int slot) {
        new PresetSelectorGui(context, ConfigManager.PRESETS::values, null);
    }

    public static void playerPresets(EditingContext context, int slot) {
        PlayerData data = PlayerData.get(context.player);
        new PresetSelectorGui(context, () -> data.presets, p -> {
            data.presets.remove(p);
            data.save(context.player);
        });
    }

    public PresetSelectorGui(EditingContext context, Supplier<Collection<ArmorStandPreset>> supplier, Consumer<ArmorStandPreset> remover) {
        super(context, class_3917.field_17326, false);
        this.setTitle((class_2561)TextUtils.gui("presets_title", new Object[0]));
        this.presets = new ArrayList<ArmorStandPreset>(supplier.get());
        this.presetSupplier = supplier;
        this.remover = remover;
        this.buildUi();
        this.open();
    }

    @Override
    protected void buildUi() {
        for (int x = 0; x < 9; ++x) {
            this.setSlot(x + 18, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8871).hideTooltip());
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        int maxPage = Math.ceilDiv(this.presets.size(), 18);
        for (int x = 0; x < 18; ++x) {
            this.clearSlot(x);
            if (this.page * 18 + x >= this.presets.size()) continue;
            ArmorStandPreset preset = this.presets.get(this.page * 18 + x);
            GuiElementBuilder b = new GuiElementBuilder(class_1802.field_8694).setName((class_2561)class_2561.method_43470((String)preset.name).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1060))).addLoreLine((class_2561)TextUtils.gui("preset_author", preset.author).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080))).setCallback((t1, t2, t3) -> {
                this.playClickSound();
                if (this.remover != null && t2.isRight && t2.shift) {
                    this.remover.accept(preset);
                    this.presets.clear();
                    this.presets.addAll(this.presetSupplier.get());
                    this.rebuildUi();
                    return;
                }
                ((PlayerExt)this.player).ase$setArmorStandEditorData(preset.asData());
                this.player.method_7353((class_2561)TextUtils.text("presets.selected", preset.name), true);
                this.openPreviousOrClose();
            });
            if (this.remover != null) {
                b.addLoreLine((class_2561)TextUtils.gui("presets.remove", new Object[0]).method_27692(class_124.field_1061));
            }
            this.setSlot(x, (GuiElementBuilderInterface)b);
        }
        this.setSlot(this.size - 5, (GuiElementBuilderInterface)this.closeButton());
        GuiElementBuilder previous = new GuiElementBuilder(this.page != 0 ? class_1802.field_8107 : class_1802.field_8240).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.previous_page").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        if (this.page != 0) {
            previous.setCallback((index, type, action) -> {
                --this.page;
                this.playClickSound();
                this.updateDisplay();
            });
        }
        this.setSlot(this.size - 8, (GuiElementBuilderInterface)previous);
        GuiElementBuilder next = new GuiElementBuilder(this.page < maxPage - 1 ? class_1802.field_8107 : class_1802.field_8240).setName((class_2561)class_2561.method_43471((String)"spectatorMenu.next_page").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
        if (this.page < maxPage - 1) {
            next.setCallback((index, type, action) -> {
                ++this.page;
                this.playClickSound();
                this.updateDisplay();
            });
        }
        this.setSlot(this.size - 2, (GuiElementBuilderInterface)next);
    }

    @Override
    protected EditingContext.SwitchEntry asSwitchableUi() {
        ArrayList<ArmorStandPreset> preset = this.presets;
        return EditingContext.SwitchEntry.ofChest((x, y) -> new PresetSelectorGui(x, this.presetSupplier, this.remover));
    }
}

