/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.armorstandeditor.gui;

import eu.pb4.armorstandeditor.config.ConfigData;
import eu.pb4.armorstandeditor.config.ConfigManager;
import eu.pb4.armorstandeditor.gui.BaseWorldGui;
import eu.pb4.armorstandeditor.gui.EditingContext;
import eu.pb4.armorstandeditor.gui.ScaleSetGui;
import eu.pb4.armorstandeditor.util.TextUtils;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2735;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class ScaleGui
extends BaseWorldGui {
    public ScaleGui(EditingContext context, int slot) {
        super(context, slot);
        this.rebuildUi();
        this.open();
    }

    @Override
    public void onTick() {
        super.onTick();
    }

    @Override
    protected void buildUi() {
        double moveBase = (double)((int)(this.context.scaleDelta * 100.0)) / 100.0;
        this.setSlot(1, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8675, TextUtils.gui("action.scale.decrease", moveBase * 0.5), false).setCallback((x, y, z, c) -> this.changeScale(-moveBase * 0.5)));
        this.setSlot(2, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8620, TextUtils.gui("action.scale.decrease", moveBase), false).setCallback((x, y, z, c) -> this.changeScale(-moveBase)));
        this.updateMiddle();
        this.setSlot(4, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8695, TextUtils.gui("action.scale.increase", moveBase), false).setCallback((x, y, z, c) -> this.changeScale(moveBase)));
        this.setSlot(5, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8397, TextUtils.gui("action.scale.increase", moveBase * 0.5), false).setCallback((x, y, z, c) -> this.changeScale(moveBase * 0.5)));
        this.setSlot(7, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8865, "action.scale.reset", false).setCallback((x, y, z) -> {
            this.playSound((class_6880<class_3414>)class_3417.field_15015, 0.5f, 1.0f);
            this.setScale(1.0);
        }));
    }

    private void updateMiddle() {
        this.setSlot(3, (GuiElementBuilderInterface)this.baseElement(class_1802.field_8788, TextUtils.gui("action.scale.value_or_set", String.format("%.02f", Float.valueOf(this.context.armorStand.method_55693()))), false).setCallback((x, y, z) -> {
            this.playSound((class_6880<class_3414>)class_3417.field_15015, 0.5f, 1.0f);
            this.switchUi(EditingContext.SwitchEntry.ofChest(ScaleSetGui::new), true);
        }));
    }

    private void setScale(double scale) {
        this.context.armorStand.method_5996(class_5134.field_47760).method_6192(scale);
        this.updateMiddle();
    }

    public boolean onSelectedSlotChange(int slot) {
        if (this.player.method_5715()) {
            int current = this.getSelectedSlot();
            int delta = slot - current;
            double value = this.context.scaleDelta == 0.1 && delta < 0 || this.context.scaleDelta < 0.1 ? (double)((int)(this.context.scaleDelta * 100.0 + (double)delta)) / 100.0 : (double)((int)(this.context.scaleDelta * 10.0 + (double)delta)) / 10.0;
            this.context.scaleDelta = class_3532.method_15350((double)value, (double)0.0, (double)8.0);
            this.player.method_7353((class_2561)TextUtils.gui("action.scale.set_change", this.context.scaleDelta), true);
            this.playSound((class_6880<class_3414>)class_3417.field_15204, 0.5f, 1.0f);
            this.player.field_13987.method_14364((class_2596)new class_2735(this.selectedSlot));
            this.buildUi();
            return false;
        }
        return super.onSelectedSlotChange(slot);
    }

    private void changeScale(double v) {
        if (this.player.method_5715() || this.context == null) {
            return;
        }
        ConfigData conf = ConfigManager.getConfig().configData;
        this.setScale(class_3532.method_15350((double)(v + (double)this.context.armorStand.method_55693()), (double)conf.minimumScaleValue, (double)conf.maximalScaleValue));
    }

    @Override
    protected EditingContext.SwitchEntry asSwitchableUi() {
        return new EditingContext.SwitchEntry(ScaleGui::new, this.getSelectedSlot());
    }
}

