/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.armorstandeditor.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.armorstandeditor.GenericModInfo;
import eu.pb4.armorstandeditor.config.ArmorStandPreset;
import eu.pb4.armorstandeditor.config.ConfigManager;
import eu.pb4.armorstandeditor.util.PlayerExt;
import eu.pb4.armorstandeditor.util.TextUtils;
import java.util.Iterator;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class GeneralCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"armorstandeditor").requires(Permissions.require((String)"armor_stand_editor.commands.main", (boolean)true))).executes(GeneralCommands::about)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"armor_stand_editor.commands.reload", (int)4))).executes(GeneralCommands::reloadConfig))).then(class_2170.method_9247((String)"give").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(Permissions.require((String)"armor_stand_editor.commands.give", (int)2))).executes(GeneralCommands::giveTool)))).then(class_2170.method_9247((String)"save-preset").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).requires(Permissions.require((String)"armor_stand_editor.commands.save_preset", (int)3))).executes(GeneralCommands::savePreset))))).then(class_2170.method_9247((String)"delete-preset").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).requires(Permissions.require((String)"armor_stand_editor.commands.delete_preset", (int)3))).executes(GeneralCommands::deletePreset)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list-preset").requires(Permissions.require((String)"armor_stand_editor.commands.list_presets", (int)3))).executes(GeneralCommands::listPresets))));
    }

    private static int savePreset(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerExt spei = (PlayerExt)player;
        String id = (String)context.getArgument("id", String.class);
        String name = (String)context.getArgument("name", String.class);
        if (ConfigManager.INVALID_CHAR.matcher(id).matches()) {
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.command("invalid-id", id).method_27692(class_124.field_1061), false);
            return 0;
        }
        if (spei.ase$getArmorStandEditorData() != null) {
            ArmorStandPreset preset = new ArmorStandPreset(id, name, player.method_7334().name());
            preset.fromData(spei.ase$getArmorStandEditorData());
            ConfigManager.savePreset(preset);
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.command("save-preset.success", name, id), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.command("save-preset.fail", name, id).method_27692(class_124.field_1061), false);
        }
        return 0;
    }

    private static int deletePreset(CommandContext<class_2168> context) {
        String id = (String)context.getArgument("id", String.class);
        if (ConfigManager.INVALID_CHAR.matcher(id).matches()) {
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.command("invalid-id", id).method_27692(class_124.field_1061), false);
            return 0;
        }
        if (ConfigManager.deletePreset(id)) {
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.command("delete-preset.success", id), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.command("delete-preset.fail", id).method_27692(class_124.field_1061), false);
        }
        return 0;
    }

    private static int listPresets(CommandContext<class_2168> context) {
        class_5250 text = class_2561.method_43470((String)"").method_27692(class_124.field_1063);
        Iterator<ArmorStandPreset> iterator = ConfigManager.PRESETS.values().iterator();
        while (iterator.hasNext()) {
            ArmorStandPreset preset = iterator.next();
            if (preset.id.startsWith("$")) {
                text.method_10852((class_2561)class_2561.method_43470((String)preset.name).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)("buildin/" + preset.id.substring(1))).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080))));
            } else {
                text.method_10852((class_2561)class_2561.method_43470((String)preset.name).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)preset.id).method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080))));
            }
            if (!iterator.hasNext()) continue;
            text.method_10852((class_2561)class_2561.method_43470((String)", "));
        }
        ((class_2168)context.getSource()).method_9226(() -> text, false);
        return 0;
    }

    private static int giveTool(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1799 itemStack = ConfigManager.getConfig().armorStandTool.method_7854();
        class_2487 nbt = new class_2487();
        nbt.method_10556("isArmorStandEditor", true);
        itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        class_2300 entitySelector = (class_2300)context.getArgument("targets", class_2300.class);
        for (class_3222 player : entitySelector.method_9813((class_2168)context.getSource())) {
            player.method_31548().method_7398(itemStack);
            ((class_2168)context.getSource()).method_9226(() -> TextUtils.command("give", player.method_5476()), true);
        }
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        if (ConfigManager.loadConfig()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloaded config!"), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Error accrued while reloading config!").method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int about(CommandContext<class_2168> context) {
        for (class_2561 t : ((class_2168)context.getSource()).method_43737() ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((class_2168)context.getSource()).method_9226(() -> t, false);
        }
        return 1;
    }
}

