/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.block.custom;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import javax.annotation.Nullable;
import net.goo.brutality.registry.BrutalityModItems;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DustbinBlock
extends Block
implements WorldlyContainerHolder {
    public static final int MAX_LEVEL = 15;
    public static final IntegerProperty PAPERS = IntegerProperty.m_61631_((String)"papers", (int)0, (int)16);
    public static final Object2FloatMap<ItemLike> DISCARDABLES = new Object2FloatOpenHashMap();
    private static final VoxelShape OUTER_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape[] SHAPES = (VoxelShape[])Util.m_137469_((Object)new VoxelShape[17], voxelShapes -> {
        for (int i = 0; i < 16; ++i) {
            voxelShapes[i] = Shapes.m_83113_((VoxelShape)OUTER_SHAPE, (VoxelShape)Block.m_49796_((double)2.5, (double)Math.max(0.1, (double)i), (double)2.5, (double)13.5, (double)16.0, (double)13.5), (BooleanOp)BooleanOp.f_82685_);
        }
        voxelShapes[16] = voxelShapes[15];
    });

    public static void bootStrap() {
        DISCARDABLES.defaultReturnValue(-1.0f);
        DustbinBlock.add(0.3f, (ItemLike)Items.f_42516_);
        DustbinBlock.add(0.75f, (ItemLike)Items.f_42690_);
        DustbinBlock.add(0.7f, (ItemLike)BrutalityModItems.IMPORTANT_DOCUMENTS.get());
        DustbinBlock.add(0.5f, (ItemLike)Items.f_42517_);
        DustbinBlock.add(0.5f, (ItemLike)Items.f_42614_);
        DustbinBlock.add(0.5f, (ItemLike)Items.f_42615_);
    }

    private static void add(float pChance, ItemLike pItem) {
        DISCARDABLES.put((Object)pItem.m_5456_(), pChance);
    }

    public DustbinBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PAPERS, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[(Integer)pState.m_61143_((Property)PAPERS)];
    }

    public VoxelShape m_6079_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return OUTER_SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[0];
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if ((Integer)pState.m_61143_((Property)PAPERS) == 15) {
            pLevel.m_186460_(pPos, pState.m_60734_(), 20);
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int i = (Integer)pState.m_61143_((Property)PAPERS);
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (i < 16 && DISCARDABLES.containsKey((Object)itemstack.m_41720_())) {
            if (i < 15 && !pLevel.f_46443_) {
                BlockState blockstate = DustbinBlock.addItem((Entity)pPlayer, pState, (LevelAccessor)pLevel, pPos, itemstack);
                pLevel.m_245747_(pPos, pState != blockstate ? SoundEvents.f_11765_ : SoundEvents.f_11764_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (i == 16) {
            DustbinBlock.extractOutput((Entity)pPlayer, pState, pLevel, pPos);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static void extractOutput(Entity pEntity, BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.f_46443_) {
            Vec3 vec3 = Vec3.m_272021_((Vec3i)pPos, (double)0.5, (double)1.01, (double)0.5).m_272010_(pLevel.f_46441_, 0.7f);
            ItemEntity itementity = new ItemEntity(pLevel, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), new ItemStack((ItemLike)Items.f_42499_));
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
        DustbinBlock.empty(pEntity, pState, (LevelAccessor)pLevel, pPos);
        pLevel.m_5594_(null, pPos, SoundEvents.f_11763_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    static BlockState empty(@Nullable Entity pEntity, BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockstate = (BlockState)pState.m_61124_((Property)PAPERS, (Comparable)Integer.valueOf(0));
        pLevel.m_7731_(pPos, blockstate, 3);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)blockstate));
        return blockstate;
    }

    static BlockState addItem(@Nullable Entity pEntity, BlockState pState, LevelAccessor pLevel, BlockPos pPos, ItemStack pStack) {
        int i = (Integer)pState.m_61143_((Property)PAPERS);
        float f = DISCARDABLES.getFloat((Object)pStack.m_41720_());
        if (!(i == 0 && f > 0.0f || pLevel.m_213780_().m_188500_() < (double)f)) {
            return pState;
        }
        int j = i + 1;
        BlockState blockstate = (BlockState)pState.m_61124_((Property)PAPERS, (Comparable)Integer.valueOf(j));
        pLevel.m_7731_(pPos, blockstate, 3);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)blockstate));
        if (j == 15) {
            pLevel.m_186460_(pPos, pState.m_60734_(), 20);
        }
        return blockstate;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((Integer)pState.m_61143_((Property)PAPERS) == 15) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)PAPERS), 3);
            pLevel.m_5594_(null, pPos, SoundEvents.f_11766_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return (Integer)pBlockState.m_61143_((Property)PAPERS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{PAPERS});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @NotNull
    public WorldlyContainer m_5840_(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = (Integer)pState.m_61143_((Property)PAPERS);
        if (i == 16) {
            return new OutputContainer(pState, pLevel, pPos, new ItemStack((ItemLike)Items.f_42499_));
        }
        return i < 15 ? new InputContainer(pState, pLevel, pPos) : new EmptyContainer();
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public OutputContainer(BlockState pState, LevelAccessor pLevel, BlockPos pPos, ItemStack pStack) {
            super(new ItemStack[]{pStack});
            this.state = pState;
            this.level = pLevel;
            this.pos = pPos;
        }

        public int m_6893_() {
            return 1;
        }

        public int @NotNull [] m_7071_(Direction pSide) {
            int[] nArray;
            if (pSide == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return false;
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return !this.changed && pDirection == Direction.DOWN && pStack.m_150930_(Items.f_42499_);
        }

        public void m_6596_() {
            DustbinBlock.empty(null, this.state, this.level, this.pos);
            this.changed = true;
        }
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public InputContainer(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
            super(1);
            this.state = pState;
            this.level = pLevel;
            this.pos = pPos;
        }

        public int m_6893_() {
            return 1;
        }

        public int @NotNull [] m_7071_(Direction pSide) {
            int[] nArray;
            if (pSide == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return !this.changed && pDirection == Direction.UP && ComposterBlock.f_51914_.containsKey((Object)pItemStack.m_41720_());
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return false;
        }

        public void m_6596_() {
            ItemStack itemstack = this.m_8020_(0);
            if (!itemstack.m_41619_()) {
                this.changed = true;
                BlockState blockstate = DustbinBlock.addItem(null, this.state, this.level, this.pos, itemstack);
                this.level.m_46796_(1500, this.pos, blockstate != this.state ? 1 : 0);
                this.m_8016_(0);
            }
        }
    }

    static class EmptyContainer
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyContainer() {
            super(0);
        }

        public int @NotNull [] m_7071_(Direction pSide) {
            return new int[0];
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return false;
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return false;
        }
    }
}

