/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.client.renderers.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.goo.brutality.block.block_entity.WhiteFilingCabinetBlockEntity;
import net.goo.brutality.block.custom.WhiteFilingCabinetBlock;
import net.goo.brutality.registry.BrutalityModBlocks;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class FilingCabinetBlockEntityRenderer<T extends WhiteFilingCabinetBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ModelLayerLocation FILING_CABINET_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"filing_cabinet"), "main");
    private static final String CABINET = "cabinet";
    private static final String UPPER_DRAWER = "upper_drawer";
    private static final String LOWER_DRAWER = "lower_drawer";
    private final ModelPart cabinet;
    private final ModelPart upperDrawer;
    private final ModelPart lowerDrawer;
    private static final Map<Block, Material> MATERIAL_MAP = new HashMap<Block, Material>();

    public FilingCabinetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(FILING_CABINET_LAYER);
        this.cabinet = modelPart.m_171324_(CABINET);
        this.upperDrawer = modelPart.m_171324_(UPPER_DRAWER);
        this.lowerDrawer = modelPart.m_171324_(LOWER_DRAWER);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(CABINET, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.m_171423_((float)16.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        partDefinition.m_171599_(UPPER_DRAWER, CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(1.0f, 9.0f, 7.9f, 14.0f, 6.0f, 8.0f), PartPose.m_171423_((float)16.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        partDefinition.m_171599_(LOWER_DRAWER, CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(1.0f, 1.0f, 7.9f, 14.0f, 6.0f, 8.0f), PartPose.m_171423_((float)16.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(WhiteFilingCabinetBlockEntity blockEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)WhiteFilingCabinetBlock.FACING);
        float upperOpenness = blockEntity.getOpenness(true, partialTicks);
        float lowerOpenness = blockEntity.getOpenness(false, partialTicks);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        Material material = MATERIAL_MAP.getOrDefault(state.m_60734_(), MATERIAL_MAP.get(BrutalityModBlocks.WHITE_FILING_CABINET.get()));
        VertexConsumer vertexConsumer = material.m_119194_(buffer, RenderType::m_110452_);
        this.cabinet.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.upperDrawer.f_104202_ = upperOpenness * 8.0f;
        this.upperDrawer.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.lowerDrawer.f_104202_ = lowerOpenness * 8.0f;
        this.lowerDrawer.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.m_85849_();
    }

    static {
        MATERIAL_MAP.put((Block)BrutalityModBlocks.WHITE_FILING_CABINET.get(), new Material(ResourceLocation.parse((String)"textures/atlas/blocks.png"), ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"block/white_filing_cabinet")));
        MATERIAL_MAP.put((Block)BrutalityModBlocks.GRAY_FILING_CABINET.get(), new Material(ResourceLocation.parse((String)"textures/atlas/blocks.png"), ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"block/gray_filing_cabinet")));
    }
}

