/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.client.renderers.curio;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.goo.brutality.client.models.BrutalityCurioModel;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.RenderUtils;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class BrutalityCurioRenderer<I extends BrutalityCurioItem>
extends GeoArmorRenderer<I>
implements ICurioRenderer {
    public BrutalityCurioRenderer(Consumer<BrutalityCurioRenderer<I>> layerConfigurator) {
        super(new BrutalityCurioModel());
        layerConfigurator.accept(this);
    }

    public BrutalityCurioRenderer() {
        super(new BrutalityCurioModel());
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animatable = (BrutalityCurioItem)stack.m_41720_();
        this.currentEntity = slotContext.entity();
        this.currentStack = stack;
        this.baseModel = renderLayerParent.m_7200_() instanceof HumanoidModel ? (HumanoidModel)renderLayerParent.m_7200_() : new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
        poseStack.m_85836_();
        this.prepForRender((Entity)slotContext.entity(), stack, EquipmentSlot.HEAD, this.baseModel);
        if (!((BrutalityCurioItem)this.animatable).translateIfSneaking() && this.currentEntity.m_6047_()) {
            poseStack.m_252880_(0.0f, -0.1875f, 0.0f);
        }
        if (!((BrutalityCurioItem)this.animatable).followBodyRotations()) {
            float bodyYaw = Mth.m_14179_((float)partialTicks, (float)slotContext.entity().f_20884_, (float)slotContext.entity().f_20883_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-bodyYaw));
        }
        RenderType renderType = this.getRenderType((I)((BrutalityCurioItem)this.animatable), this.getTextureLocation((GeoAnimatable)((BrutalityCurioItem)this.animatable)), renderTypeBuffer, partialTicks);
        VertexConsumer buffer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)renderType, (boolean)false, (boolean)stack.m_41790_());
        this.defaultRender(poseStack, (GeoAnimatable)((BrutalityCurioItem)this.animatable), renderTypeBuffer, renderType, buffer, 0.0f, partialTicks, light);
        poseStack.m_85849_();
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        this.setAllBonesVisible(true);
    }

    public RenderType getRenderType(I animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110467_((ResourceLocation)texture);
    }

    public ItemStack getCurrentItemStack() {
        return this.currentStack;
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        float zOffset;
        float yOffset;
        boolean applyCrouch;
        boolean isCrouching = this.currentEntity.m_6047_();
        boolean bl = applyCrouch = ((BrutalityCurioItem)this.animatable).translateIfSneaking() || !isCrouching;
        if (this.head != null) {
            ModelPart headPart = baseModel.f_102808_;
            if (((BrutalityCurioItem)this.animatable).followHeadRotations()) {
                RenderUtils.matchModelPartRot((ModelPart)headPart, (CoreGeoBone)this.head);
            }
            yOffset = applyCrouch ? headPart.f_104201_ : 0.0f;
            this.head.updatePosition(headPart.f_104200_, -yOffset, headPart.f_104202_);
        }
        if (this.body != null) {
            ModelPart bodyPart = baseModel.f_102810_;
            if (((BrutalityCurioItem)this.animatable).rotateIfSneaking()) {
                RenderUtils.matchModelPartRot((ModelPart)bodyPart, (CoreGeoBone)this.body);
            } else if (isCrouching) {
                this.body.setRotX(0.0f);
            }
            yOffset = applyCrouch ? bodyPart.f_104201_ : 0.0f;
            this.body.updatePosition(bodyPart.f_104200_, -yOffset, bodyPart.f_104202_);
        }
        if (this.rightArm != null) {
            ModelPart rightArmPart = baseModel.f_102811_;
            if (applyCrouch) {
                RenderUtils.matchModelPartRot((ModelPart)rightArmPart, (CoreGeoBone)this.rightArm);
            } else {
                this.rightArm.setRotX(rightArmPart.f_104203_ - 0.4f);
            }
            yOffset = applyCrouch ? rightArmPart.f_104201_ : 2.0f;
            this.rightArm.updatePosition(rightArmPart.f_104200_ + 5.0f, 2.0f - yOffset, rightArmPart.f_104202_);
        }
        if (this.leftArm != null) {
            ModelPart leftArmPart = baseModel.f_102812_;
            if (applyCrouch) {
                RenderUtils.matchModelPartRot((ModelPart)leftArmPart, (CoreGeoBone)this.leftArm);
            } else {
                this.leftArm.setRotX(leftArmPart.f_104203_ - 0.4f);
            }
            yOffset = applyCrouch ? leftArmPart.f_104201_ : 2.0f;
            this.leftArm.updatePosition(leftArmPart.f_104200_ - 5.0f, 2.0f - yOffset, leftArmPart.f_104202_);
        }
        if (this.rightLeg != null) {
            ModelPart rightLegPart = baseModel.f_102813_;
            RenderUtils.matchModelPartRot((ModelPart)rightLegPart, (CoreGeoBone)this.rightLeg);
            yOffset = applyCrouch ? rightLegPart.f_104201_ : 12.0f;
            zOffset = applyCrouch ? rightLegPart.f_104202_ : 0.0f;
            this.rightLeg.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - yOffset, zOffset);
            if (this.rightBoot != null) {
                RenderUtils.matchModelPartRot((ModelPart)rightLegPart, (CoreGeoBone)this.rightBoot);
                this.rightBoot.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - yOffset, zOffset);
            }
        }
        if (this.leftLeg != null) {
            ModelPart leftLegPart = baseModel.f_102814_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftLeg);
            yOffset = applyCrouch ? leftLegPart.f_104201_ : 12.0f;
            zOffset = applyCrouch ? leftLegPart.f_104202_ : 0.0f;
            this.leftLeg.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - yOffset, zOffset);
            if (this.leftBoot != null) {
                RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - yOffset, zOffset);
            }
        }
    }
}

