/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.datagen;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.goo.brutality.Brutality;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.mcreator.terramity.entity.GobEntity;
import net.mcreator.terramity.entity.GundalfEntity;
import net.mcreator.terramity.entity.HellrokEntity;
import net.mcreator.terramity.entity.SorceressCirceEntity;
import net.mcreator.terramity.entity.SuperSnifferEntity;
import net.mcreator.terramity.entity.TrialGuardianEntity;
import net.mcreator.terramity.entity.UltraSnifferEntity;
import net.mcreator.terramity.entity.UvogreEntity;
import net.mcreator.terramity.entity.VirtueEntity;
import net.mehvahdjukaar.moonlight.core.misc.FakeLevel;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BrutalityDataFetcher
implements DataProvider {
    private final PackOutput.PathProvider dataPath;
    private final Map<String, String> translations = new HashMap<String, String>();
    private final Map<String, String> curioTypes = new HashMap<String, String>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final DecimalFormat decimalFormat = new DecimalFormat("0.##");
    private static final Set<Class<?>> BOSSES = Set.of(GobEntity.class, SuperSnifferEntity.class, TrialGuardianEntity.class, VirtueEntity.class, GundalfEntity.class, SorceressCirceEntity.class, UltraSnifferEntity.class);
    private static final Set<Class<?>> MINIBOSSES = Set.of(UvogreEntity.class, HellrokEntity.class);

    public BrutalityDataFetcher(PackOutput output) {
        this.dataPath = output.m_245269_(PackOutput.Target.DATA_PACK, "item_data");
        this.loadTranslations();
        this.loadAllFilesFromModDirectory("terramity", "data/curios/tags/items");
        this.loadAllFilesFromModDirectory("brutality", "data/curios/tags/items");
        this.loadAllFilesFromModDirectory("lethality", "data/curios/tags/items");
    }

    private void loadTranslations() {
        this.loadMinecraftTranslations();
        this.loadTranslationFileFromJar("/assets/brutality/lang/en_us.json");
        this.loadTranslationsFromMod("terramity", "en_us.json");
        this.loadTranslationsFromMod("lethality", "en_us.json");
    }

    private void loadMinecraftTranslations() {
        block14: {
            try {
                File jarFile = new File(System.getProperty("user.home") + "/.gradle/caches/forge_gradle/minecraft_repo/versions/1.20.1/client-extra.jar");
                try (JarFile jar = new JarFile(jarFile);){
                    JarEntry entry = jar.getJarEntry("assets/minecraft/lang/en_us.json");
                    if (entry != null) {
                        try (InputStream stream = jar.getInputStream(entry);){
                            JsonObject json = (JsonObject)this.gson.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                            json.entrySet().forEach(e -> this.translations.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString()));
                            Brutality.LOGGER.debug("Loaded {} translations from Minecraft JAR", (Object)json.size());
                            break block14;
                        }
                    }
                    Brutality.LOGGER.warn("Minecraft en_us.json not found in JAR");
                }
            }
            catch (IOException e2) {
                Brutality.LOGGER.error("Failed to load Minecraft translations: {}", (Object)e2.toString());
            }
        }
    }

    private void loadTranslationFileFromJar(String resourcePath) {
        try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
            if (in != null) {
                JsonObject json = (JsonObject)this.gson.fromJson((Reader)new InputStreamReader(in), JsonObject.class);
                json.entrySet().forEach(entry -> this.translations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                Brutality.LOGGER.debug("Loaded {} translations from internal {}", (Object)json.size(), (Object)resourcePath);
            } else {
                Brutality.LOGGER.warn("Internal translation file not found: {}", (Object)resourcePath);
            }
        }
        catch (Exception e) {
            Brutality.LOGGER.error("Failed to load internal translations from {}: {}", (Object)resourcePath, (Object)e.toString());
        }
    }

    private void loadTranslationsFromMod(String modId, String langFile) {
        try {
            ModFile modFile = (ModFile)ModList.get().getModFileById(modId).getFile();
            Path path = modFile.findResource(new String[]{"assets/" + modId + "/lang/" + langFile});
            this.loadTranslationFileFromPath(path);
        }
        catch (Exception e) {
            Brutality.LOGGER.error("Failed to load translations from mod {}: {}", (Object)modId, (Object)e.toString());
        }
    }

    private void loadAllFilesFromModDirectory(String modId, String directoryPath) {
        try {
            ModFile modFile = (ModFile)ModList.get().getModFileById(modId).getFile();
            Path modRoot = modFile.findResource(new String[]{""});
            Files.walk(modRoot.resolve(directoryPath), new FileVisitOption[0]).filter(path -> path.toString().endsWith(".json")).forEach(this::processCurioTypeFile);
        }
        catch (Exception e) {
            Brutality.LOGGER.error("Failed to load files from {} in mod {}: {}", new Object[]{directoryPath, modId, e.toString()});
        }
    }

    private void processCurioTypeFile(Path filePath) {
        try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);){
            JsonObject json = (JsonObject)this.gson.fromJson((Reader)new InputStreamReader(in), JsonObject.class);
            String fileName = filePath.getFileName().toString();
            String type = fileName.substring(0, fileName.lastIndexOf(46));
            if (json.has("values")) {
                JsonArray items = json.getAsJsonArray("values");
                for (JsonElement item : items) {
                    String itemId = item.getAsString();
                    this.curioTypes.put(itemId, type);
                }
            }
            Brutality.LOGGER.debug("processCurioTypeFile# Loaded {} items from {}", (Object)json.getAsJsonArray("values").size(), (Object)filePath);
        }
        catch (Exception e) {
            Brutality.LOGGER.error("Failed to process file {}: {}", (Object)filePath, (Object)e.toString());
        }
    }

    private void loadTranslationFileFromPath(Path path) {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            JsonObject json = (JsonObject)this.gson.fromJson((Reader)new InputStreamReader(in), JsonObject.class);
            json.entrySet().forEach(entry -> this.translations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
            Brutality.LOGGER.debug("Loaded {} translations from {}", (Object)json.size(), (Object)path);
        }
        catch (Exception e) {
            Brutality.LOGGER.error("Failed to load translations from path {}: {}", (Object)path, (Object)e.toString());
        }
    }

    public static RegistryAccess.Frozen getFakeRegistryAccess() {
        ResourceKey DIMENSION_TYPE_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dimension_type"));
        ResourceKey OVERWORLD_DIM_TYPE_KEY = ResourceKey.m_135785_((ResourceKey)DIMENSION_TYPE_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"overworld"));
        MappedRegistry dimensionTypeRegistry = new MappedRegistry(DIMENSION_TYPE_KEY, Lifecycle.stable(), false);
        DimensionType dummyDimType = new DimensionType(OptionalLong.of(6000L), true, false, false, true, 1.0, true, true, 0, 384, 384, BlockTags.f_13058_, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"overworld"), 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)ConstantInt.m_146483_((int)0), 0));
        dimensionTypeRegistry.m_255290_(OVERWORLD_DIM_TYPE_KEY, (Object)dummyDimType, Lifecycle.stable());
        ResourceKey DAMAGE_TYPE_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"damage_type"));
        MappedRegistry damageTypeRegistry = new MappedRegistry(DAMAGE_TYPE_KEY, Lifecycle.stable(), false);
        ArrayList<ResourceKey> damageKeys = new ArrayList<ResourceKey>();
        for (Field field : DamageTypes.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ResourceKey.class)) continue;
            try {
                ResourceKey key = (ResourceKey)field.get(null);
                damageKeys.add(key);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (ResourceKey key : damageKeys) {
            damageTypeRegistry.m_255290_(key, (Object)new DamageType(key.m_135782_().m_135815_(), 0.0f), Lifecycle.stable());
        }
        return new RegistryAccess.ImmutableRegistryAccess(Map.of(DIMENSION_TYPE_KEY, dimensionTypeRegistry, DAMAGE_TYPE_KEY, damageTypeRegistry)).m_203557_();
    }

    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList itemDataList = new ArrayList();
        ArrayList effectDataList = new ArrayList();
        ArrayList entityDataList = new ArrayList();
        RegistryAccess.Frozen fakeRegistryAccess = BrutalityDataFetcher.getFakeRegistryAccess();
        ForgeRegistries.ITEMS.forEach(item -> {
            String modId = item.getCreatorModId(item.m_7968_());
            if (this.shouldProcess(modId)) {
                ItemData data = this.processItem((Item)item);
                itemDataList.add(data);
            }
        });
        ForgeRegistries.MOB_EFFECTS.forEach(effect -> {
            String modId;
            ResourceLocation registryName = ForgeRegistries.MOB_EFFECTS.getKey(effect);
            if (registryName != null && this.shouldProcess(modId = registryName.m_135827_())) {
                EffectData data = this.processEffect((MobEffect)effect, modId);
                effectDataList.add(data);
            }
        });
        ForgeRegistries.ENTITY_TYPES.forEach(entity -> {
            String modId;
            ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey(entity);
            if (registryName != null && this.shouldProcess(modId = registryName.m_135827_())) {
                EntityData data = this.processEntity((EntityType<? extends Entity>)entity, modId, fakeRegistryAccess);
                entityDataList.add(data);
            }
        });
        Path itemPath = this.dataPath.m_245731_(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"item_stats"));
        Path effectPath = this.dataPath.m_245731_(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"effect_stats"));
        Path entityPath = this.dataPath.m_245731_(ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)"entity_stats"));
        CompletableFuture itemFuture = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.gson.toJsonTree(itemDataList), (Path)itemPath);
        CompletableFuture effectFuture = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.gson.toJsonTree(effectDataList), (Path)effectPath);
        CompletableFuture entityFuture = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.gson.toJsonTree(entityDataList), (Path)entityPath);
        return CompletableFuture.allOf(itemFuture, effectFuture, entityFuture);
    }

    private boolean shouldProcess(String modId) {
        return modId != null && (modId.equalsIgnoreCase("brutality") || modId.equalsIgnoreCase("terramity") || modId.equalsIgnoreCase("lethality"));
    }

    private EffectData processEffect(MobEffect effect, String modId) {
        EffectData data = new EffectData();
        data.id = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)).m_135815_();
        data.namespace = modId;
        data.name = this.translations.getOrDefault(effect.m_19481_(), BrutalityDataFetcher.fallbackName(effect.m_19481_()));
        data.category = effect.m_19483_().toString().toLowerCase();
        return data;
    }

    private EntityData processEntity(EntityType<? extends Entity> entity, String modId, RegistryAccess.Frozen registryAccess) {
        EntityData data = new EntityData();
        data.id = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entity)).m_135815_();
        data.namespace = modId;
        data.name = this.translations.getOrDefault(entity.m_20675_(), BrutalityDataFetcher.fallbackName(entity.m_20675_()));
        data.height = String.valueOf(entity.m_20679_());
        data.width = String.valueOf(entity.m_20679_());
        try {
            FakeLevel fakeLevel = FakeLevel.getDefault((boolean)false, (RegistryAccess)registryAccess);
            Entity entityInstance = entity.m_20615_((Level)fakeLevel);
            if (entityInstance instanceof LivingEntity) {
                MobType species;
                LivingEntity living = (LivingEntity)entityInstance;
                data.health = String.valueOf(living.m_21233_());
                data.armor = String.valueOf(living.m_21230_());
                data.xpReward = String.valueOf(living.m_213860_());
                for (Class<?> bossClass : BOSSES) {
                    if (!bossClass.isInstance(entityInstance)) continue;
                    data.type = "boss";
                    break;
                }
                for (Class<?> miniBossClass : MINIBOSSES) {
                    if (!miniBossClass.isInstance(entityInstance)) continue;
                    data.type = "miniboss";
                    break;
                }
                data.species = (species = living.m_6336_()) == MobType.f_21640_ ? "unknown" : (species == MobType.f_21641_ ? "undead" : (species == MobType.f_21642_ ? "arthropod" : (species == MobType.f_21643_ ? "illager" : (species == MobType.f_21644_ ? "water" : "custom"))));
                data.category = entityInstance instanceof Monster ? "hostile" : (entityInstance instanceof Animal || entityInstance instanceof AmbientCreature ? "passive" : (entityInstance instanceof PathfinderMob ? "neutral" : "unknown"));
            }
        }
        catch (Exception e) {
            Brutality.LOGGER.warn("Failed to create FakeLevel or entity: {}", (Object)e.getMessage());
        }
        return data;
    }

    private ItemData processItem(Item item) {
        ItemStack stack = item.m_7968_();
        ItemData data = new ItemData();
        data.id = item.toString();
        data.namespace = item.getCreatorModId(stack);
        data.name = this.translations.getOrDefault(item.m_5524_(), BrutalityDataFetcher.fallbackName(item.m_5524_()));
        this.analyzeItemType(item, stack, data);
        this.analyzeFoodProperties(item, stack, data);
        this.analyzeAttributes(item, stack, data);
        this.analyzeDurability(item, stack, data);
        this.analyzeRarity(item, stack, data);
        if (stack.m_41792_()) {
            this.analyzeEnchantability(stack, data);
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            this.analyzeArmorMaterial(armorItem, data);
        }
        this.determineCategory(data, item);
        return data;
    }

    private void analyzeEnchantability(ItemStack stack, ItemData data) {
        data.allowedEnchantments = this.getAllowedEnchants(stack).toString();
        data.enchantmentValue = String.valueOf(stack.getEnchantmentValue());
    }

    private List<String> getAllowedEnchants(ItemStack stack) {
        ArrayList<String> allowed = new ArrayList<String>();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            if (!enchantment.m_6081_(stack)) continue;
            allowed.add(this.translations.getOrDefault(enchantment.m_44704_(), String.valueOf(enchantment.m_44700_(0))));
        }
        return allowed;
    }

    private void analyzeItemType(Item item, ItemStack stack, ItemData data) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.analyzeBlockItem(blockItem, data);
        } else if (item instanceof BrutalityGeoItem) {
            BrutalityGeoItem geoItem = (BrutalityGeoItem)item;
            data.itemType = geoItem.getCategoryAsString().toLowerCase();
        } else if (item instanceof ICurioItem) {
            data.itemType = "curio";
            data.category = this.determineCurioType(item);
        } else {
            data.itemType = this.determineVanillaItemType(stack);
        }
    }

    private void analyzeArmorMaterial(ArmorItem item, ItemData data) {
        data.armorMaterial = item.m_40401_().m_6082_();
        data.armorValue = String.valueOf(item.m_40404_());
        data.armorToughness = String.valueOf(item.m_40405_());
        data.armorType = String.valueOf(item.m_266204_());
    }

    private void analyzeBlockItem(BlockItem blockItem, ItemData data) {
        data.itemType = "block";
        Block block = blockItem.m_40614_();
        data.blockType = BlockTypeAnalyzer.getBlockType(block);
    }

    private String determineVanillaItemType(ItemStack stack) {
        for (Map.Entry<Predicate<ItemStack>, String> entry : EquipmentTypeMap.VANILLA_TYPES.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue();
        }
        return "generic";
    }

    private void analyzeFoodProperties(Item item, ItemStack stack, ItemData data) {
        FoodProperties foodProps = item.getFoodProperties(stack, null);
        if (foodProps != null) {
            data.itemType = "food";
            data.foodType = foodProps.m_38746_() ? "meat" : "non-meat";
            data.foodEffects = FoodEffectSerializer.serializeEffects(foodProps.m_38749_());
        }
    }

    private void analyzeAttributes(Item item, ItemStack stack, ItemData data) {
        Multimap attributes = item.getAttributeModifiers(EquipmentSlot.MAINHAND, stack);
        if (attributes != null) {
            Collection dmg = attributes.get((Object)Attributes.f_22281_);
            Collection spd = attributes.get((Object)Attributes.f_22283_);
            if (!dmg.isEmpty()) {
                data.attackDamage = this.decimalFormat.format(((AttributeModifier)dmg.iterator().next()).m_22218_());
            }
            if (!spd.isEmpty()) {
                data.attackSpeed = this.decimalFormat.format(4.0 + ((AttributeModifier)spd.iterator().next()).m_22218_());
            }
        }
    }

    private void analyzeDurability(Item item, ItemStack stack, ItemData data) {
        if (item.getMaxDamage(stack) != 0) {
            data.durability = item.getMaxDamage(stack);
        }
    }

    private void analyzeRarity(Item item, ItemStack stack, ItemData data) {
        data.rarity = item.m_41460_(stack).toString().toLowerCase();
    }

    private String determineCurioType(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        String fullId = itemId.toString();
        return this.curioTypes.getOrDefault(fullId, "curio");
    }

    private void determineCategory(ItemData data, Item item) {
        try {
            BrutalityCategories.ItemType itemType = BrutalityCategories.ItemType.valueOf(data.itemType.toUpperCase(Locale.ROOT));
            if (CategoryDeterminer.WEAPONS.contains(itemType)) {
                data.category = "weapon";
                return;
            }
            if (CategoryDeterminer.TOOLS.contains(itemType)) {
                data.category = "tool";
                return;
            }
            if (itemType == BrutalityCategories.ItemType.ARMOR) {
                data.category = "armor";
                return;
            }
        }
        catch (IllegalArgumentException itemType) {
            // empty catch block
        }
        String curioType = this.determineCurioType(item);
        if (!"curio".equals(curioType)) {
            data.itemType = curioType;
            data.category = "curio";
            return;
        }
        try {
            BrutalityCategories.CurioType.valueOf(data.itemType.toUpperCase(Locale.ROOT));
            data.category = "curio";
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            data.category = "generic";
            return;
        }
    }

    private static String fallbackName(String descId) {
        String[] parts = descId.split("\\.");
        return parts.length > 2 ? parts[2] : descId;
    }

    @NotNull
    public String m_6055_() {
        return "Brutality Item Stats Provider";
    }

    private static class EffectData {
        String namespace;
        String id;
        String name;
        String category;

        private EffectData() {
        }
    }

    private static class EntityData {
        String namespace;
        String id;
        String name;
        String category;
        String type;
        String xpReward;
        String health;
        String width;
        String height;
        String armor;
        String species;

        private EntityData() {
        }
    }

    private static class ItemData {
        String allowedEnchantments;
        String namespace;
        String id;
        String name;
        Integer durability;
        String attackDamage;
        String attackSpeed;
        String rarity;
        String itemType;
        String category;
        String blockType;
        String foodType;
        String foodEffects;
        String armorMaterial;
        String armorValue;
        String armorToughness;
        String armorType;
        String enchantmentValue;

        private ItemData() {
        }
    }

    private static class BlockTypeAnalyzer {
        private static final Map<Class<? extends Block>, String> BLOCK_TYPE_MAP = Map.ofEntries(Map.entry(StairBlock.class, "stair"), Map.entry(SlabBlock.class, "slab"), Map.entry(FenceBlock.class, "fence"), Map.entry(WallBlock.class, "wall"), Map.entry(DoorBlock.class, "door"), Map.entry(TrapDoorBlock.class, "trapdoor"), Map.entry(ButtonBlock.class, "button"), Map.entry(PressurePlateBlock.class, "pressure_plate"), Map.entry(LeavesBlock.class, "leaves"), Map.entry(SaplingBlock.class, "sapling"), Map.entry(FlowerBlock.class, "flower"), Map.entry(CropBlock.class, "crop"), Map.entry(BaseEntityBlock.class, "tile_entity"));

        private BlockTypeAnalyzer() {
        }

        public static String getBlockType(Block block) {
            return BLOCK_TYPE_MAP.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(block)).findFirst().map(Map.Entry::getValue).orElse("basic");
        }
    }

    private static class EquipmentTypeMap {
        static final Map<Predicate<ItemStack>, String> VANILLA_TYPES = new LinkedHashMap<Predicate<ItemStack>, String>(){
            {
                this.put(stack -> stack.m_41720_() instanceof SwordItem || stack.m_204117_(ItemTags.f_271388_), "sword");
                this.put(stack -> stack.m_41720_() instanceof PickaxeItem || stack.m_204117_(ItemTags.f_271360_), "pickaxe");
                this.put(stack -> stack.m_41720_() instanceof AxeItem || stack.m_204117_(ItemTags.f_271207_), "axe");
                this.put(stack -> stack.m_41720_() instanceof ShovelItem || stack.m_204117_(ItemTags.f_271138_), "shovel");
                this.put(stack -> stack.m_41720_() instanceof HoeItem || stack.m_204117_(ItemTags.f_271298_), "hoe");
                this.put(stack -> stack.m_41720_() instanceof BowItem, "bow");
                this.put(stack -> stack.m_41720_() instanceof CrossbowItem, "crossbow");
                this.put(stack -> stack.m_41720_() instanceof TridentItem, "trident");
                this.put(stack -> stack.m_41720_() instanceof ArmorItem, "armor");
                this.put(stack -> stack.m_41720_() instanceof ElytraItem, "elytra");
                this.put(stack -> stack.m_41720_() instanceof ShieldItem, "shield");
                this.put(stack -> stack.m_41720_() instanceof FishingRodItem, "fishing_rod");
                this.put(stack -> stack.m_41720_() instanceof FlintAndSteelItem, "flint_and_steel");
                this.put(stack -> stack.m_41720_() instanceof ShearsItem, "shears");
                this.put(stack -> stack.m_41720_() instanceof CompassItem, "compass");
            }
        };

        private EquipmentTypeMap() {
        }
    }

    private static class FoodEffectSerializer {
        private FoodEffectSerializer() {
        }

        public static String serializeEffects(List<Pair<MobEffectInstance, Float>> effects) {
            if (effects == null || effects.isEmpty()) {
                return "[]";
            }
            ArrayList<Map<String, Object>> effectsList = new ArrayList<Map<String, Object>>();
            for (Pair<MobEffectInstance, Float> effectPair : effects) {
                MobEffectInstance effect = (MobEffectInstance)effectPair.getFirst();
                if (effect == null) continue;
                effectsList.add(FoodEffectSerializer.createEffectData(effect, ((Float)effectPair.getSecond()).floatValue()));
            }
            return new Gson().toJson(effectsList);
        }

        private static Map<String, Object> createEffectData(MobEffectInstance effect, float probability) {
            HashMap<String, Object> effectData = new HashMap<String, Object>();
            effectData.put("effect", effect.m_19544_().m_19482_().getString());
            effectData.put("duration", effect.m_19557_());
            effectData.put("amplifier", effect.m_19564_());
            effectData.put("probability", Float.valueOf(probability));
            return effectData;
        }
    }

    private static class CategoryDeterminer {
        static final Set<BrutalityCategories.ItemType> WEAPONS = EnumSet.of(BrutalityCategories.ItemType.SWORD, new BrutalityCategories.ItemType[]{BrutalityCategories.ItemType.AXE, BrutalityCategories.ItemType.HAMMER, BrutalityCategories.ItemType.TRIDENT, BrutalityCategories.ItemType.SCYTHE, BrutalityCategories.ItemType.BOW, BrutalityCategories.ItemType.SPEAR, BrutalityCategories.ItemType.STAFF});
        static final Set<BrutalityCategories.ItemType> TOOLS = EnumSet.of(BrutalityCategories.ItemType.PICKAXE);

        private CategoryDeterminer() {
        }
    }
}

