/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.base;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.List;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public abstract class BrutalityAbstractArrow
extends AbstractArrow
implements BrutalityGeoEntity {
    private final IntOpenHashSet ignoredEntities = new IntOpenHashSet();
    public boolean collideWithBlocks = true;

    protected BrutalityAbstractArrow(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BrutalityAbstractArrow(EntityType<? extends AbstractArrow> trident, LivingEntity pShooter, Level pLevel) {
        super(trident, pShooter, pLevel);
    }

    public BrutalityAbstractArrow(@NotNull EntityType<? extends AbstractArrow> pEntityType, Level level, double x, double y, double z) {
        super(pEntityType, x, y, z, level);
    }

    public float getAirDrag() {
        return 0.99f;
    }

    public boolean shouldYawToMovement() {
        return true;
    }

    public boolean shouldPitchToMovement() {
        return true;
    }

    public float getGravity() {
        return 0.05f;
    }

    protected int getInGroundLifespan() {
        return 1200;
    }

    protected void m_6901_() {
        if (this.f_36704_ >= this.getInGroundLifespan()) {
            this.m_146870_();
        }
    }

    protected int getLifespan() {
        return 1200;
    }

    protected boolean shouldUpdateArrowCount() {
        return true;
    }

    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_11685_;
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        if (!this.f_150164_) {
            this.m_146852_(GameEvent.f_157778_, this.m_19749_());
            this.f_150164_ = true;
        }
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        this.m_6075_();
        if (this.f_19797_ >= this.getLifespan()) {
            this.m_146870_();
        }
        boolean noPhysics = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (this.collideWithBlocks && !blockstate.m_60795_() && !noPhysics && !(voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.m_20095_();
        }
        this.m_6901_();
        if (this.f_36703_ && !noPhysics) {
            if (this.f_36696_ != blockstate && this.m_36798_()) {
                this.m_36799_();
            }
            ++this.f_36704_;
        } else {
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            Vec3 vec33 = vec32.m_82549_(vec3);
            BlockHitResult hitresult = this.m_9236_().m_45547_(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !noPhysics) {
                    ProjectileImpactEvent.ImpactResult result = ForgeEventFactory.onProjectileImpactResultNullable((Projectile)this, (HitResult)hitresult);
                    if (result == null) {
                        if (hitresult.m_6662_() != HitResult.Type.ENTITY) break;
                        result = ProjectileImpactEvent.ImpactResult.SKIP_ENTITY;
                    }
                    switch (result) {
                        case SKIP_ENTITY: {
                            if (hitresult.m_6662_() != HitResult.Type.ENTITY) {
                                this.m_6532_((HitResult)hitresult);
                                this.f_19812_ = true;
                                break;
                            }
                            this.ignoredEntities.add(entityhitresult.m_82443_().m_19879_());
                            entityhitresult = null;
                            break;
                        }
                        case STOP_AT_CURRENT_NO_DAMAGE: {
                            this.m_146870_();
                            entityhitresult = null;
                            break;
                        }
                        case STOP_AT_CURRENT: {
                            this.m_36767_((byte)0);
                        }
                        case DEFAULT: {
                            this.m_6532_((HitResult)hitresult);
                            this.f_19812_ = true;
                        }
                    }
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            if (this.m_213877_()) {
                return;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (this.shouldYawToMovement()) {
                if (noPhysics) {
                    this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
                } else {
                    this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
                }
            }
            if (this.shouldPitchToMovement()) {
                this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            }
            this.m_146926_(BrutalityAbstractArrow.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(BrutalityAbstractArrow.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = this.getAirDrag();
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.m_6882_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !noPhysics) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)this.getGravity(), vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        DamageSource damagesource;
        Entity entity1;
        Entity entity = pResult.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.m_36789_()), (double)0.0, (double)2.147483647E9));
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity.m_19879_());
        }
        if (this.m_36792_()) {
            long j = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.m_19749_()) == null) {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity);
            }
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.shouldUpdateArrowCount() && !this.m_9236_().f_46443_ && this.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.m_150123_() > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6 * d0);
                    if (vec3.m_82556_() > 0.0) {
                        livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
                if (livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add(livingentity);
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity1;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, (Collection)this.f_36702_);
                    } else if (!entity.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, List.of(entity));
                    }
                }
            }
            this.m_5496_(this.getHitEntitySoundEvent(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_146870_();
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        return super.m_5603_(entity) && (this.f_36701_ == null || !this.f_36701_.contains(entity.m_19879_())) && !this.ignoredEntities.contains(entity.m_19879_());
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (this.collideWithBlocks) {
            this.f_36696_ = this.m_9236_().m_8055_(pResult.m_82425_());
            super.m_8060_(pResult);
            Vec3 vec3 = pResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_20256_(vec3);
            Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
            this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            this.f_36703_ = true;
            this.f_36706_ = 7;
            this.m_36762_(false);
            this.m_36767_((byte)0);
            this.m_36793_(false);
            this.m_36723_();
        }
    }
}

