/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.base;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractArrow;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BrutalityAbstractPhysicsProjectile
extends BrutalityAbstractArrow
implements BrutalityGeoEntity {
    protected int bounceCount = 0;
    public float prevRoll;
    public float roll;
    public float prevYaw;
    public float yaw;
    public float prevPitch;
    public float pitch;
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BrutalityAbstractPhysicsProjectile(EntityType<? extends AbstractArrow> trident, LivingEntity pShooter, Level pLevel) {
        super(trident, pShooter, pLevel);
    }

    protected BrutalityAbstractPhysicsProjectile(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static <T extends BrutalityAbstractPhysicsProjectile> RegistryObject<EntityType<T>> register(String name, EntityType.EntityFactory<T> factory, DeferredRegister<EntityType<?>> registry, float width, float height) {
        return registry.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)MobCategory.MISC).m_20699_(width, height).m_20702_(64).setUpdateInterval(20).m_20712_(name));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 look = livingEntity.m_20154_().m_82490_(livingEntity.m_21133_(Attributes.f_22282_));
            this.m_20256_(look);
            this.f_19864_ = true;
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevRoll = this.roll;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        Vec3 motion = this.m_20184_();
        float speed = (float)motion.m_82553_();
        if ((double)speed > 0.25 && !this.f_36703_) {
            if (!this.lockRoll()) {
                this.roll += speed * this.getRotationSpeed();
            }
            if (!this.lockYaw()) {
                this.yaw = (float)Math.atan2(motion.f_82481_, motion.f_82479_) * 57.295776f - 90.0f;
            }
            if (!this.lockPitch()) {
                this.pitch = (float)Math.atan2(motion.f_82480_, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)) * 57.295776f;
            }
        }
    }

    protected float getRotationSpeed() {
        return 30.0f;
    }

    protected boolean lockRoll() {
        return false;
    }

    protected boolean lockYaw() {
        return false;
    }

    protected boolean lockPitch() {
        return false;
    }

    protected int getBounceCount() {
        return 5;
    }

    @Override
    protected void m_8060_(BlockHitResult hitResult) {
        if (this.f_36703_) {
            super.m_8060_(hitResult);
            return;
        }
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.f_36706_ = 7;
        ++this.bounceCount;
        if (this.bounceCount > this.getBounceCount()) {
            this.f_36703_ = true;
            super.m_8060_(hitResult);
            return;
        }
        if (this.f_36703_) {
            return;
        }
        Vec3 normal = Vec3.m_82528_((Vec3i)hitResult.m_82434_().m_122436_());
        Vec3 incoming = this.m_20184_();
        Vec3 reflected = incoming.m_82546_(normal.m_82490_(2.0 * incoming.m_82526_(normal)));
        this.m_20256_(reflected.m_82490_((double)this.getBounciness()));
        Vec3 newPos = hitResult.m_82450_().m_82549_(reflected.m_82541_().m_82490_(0.1));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        if (this.m_36796_() > 0) {
            this.m_36767_((byte)(this.m_36796_() - 1));
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected float getBounciness() {
        return 0.175f;
    }

    protected void m_6532_(HitResult hitResult) {
        if (this.f_36703_) {
            return;
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)hitResult);
        } else {
            super.m_6532_(hitResult);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public float getModelHeight() {
        return 1.0f;
    }
}

