/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.base;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractArrow;
import net.goo.brutality.registry.BrutalityDamageTypes;
import net.goo.brutality.util.ModUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BrutalityAbstractThrowingProjectile
extends BrutalityAbstractArrow
implements BrutalityGeoEntity {
    protected boolean dealtDamage = false;
    protected Float damage;
    protected final ResourceKey<DamageType> damageTypeResourceKey;
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BrutalityAbstractThrowingProjectile(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel);
        this.damageTypeResourceKey = damageTypeResourceKey;
    }

    public BrutalityAbstractThrowingProjectile(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, (LivingEntity)player, pLevel);
        this.damageTypeResourceKey = damageTypeResourceKey;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.damage == null) {
            this.damage = Float.valueOf(ModUtils.getAttackDamage(this.m_19749_()));
        }
    }

    protected float getDamageMultiplier() {
        return 1.0f;
    }

    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_12515_;
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_12514_;
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.dealtDamage = pCompound.m_128471_("DealtDamage");
    }

    @Override
    protected boolean m_5603_(@NotNull Entity entity) {
        return entity != this.m_19749_() && !this.getClass().isInstance(entity);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("DealtDamage", this.dealtDamage);
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_8060_(BlockHitResult pResult) {
        if (this.collideWithBlocks) {
            super.m_8060_(pResult);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        DamageSource damagesource;
        Entity target = pResult.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource damageSource = damagesource = this.damageTypeResourceKey == BrutalityDamageTypes.THROWING_PIERCE ? BrutalityDamageTypes.throwing_pierce(owner, (Entity)this) : BrutalityDamageTypes.throwing_blunt(owner, (Entity)this);
        if (this.m_36796_() > 0) {
            this.m_36767_((byte)(this.m_36796_() - 1));
        } else {
            this.dealtDamage = true;
        }
        SoundEvent soundEvent = this.getHitEntitySoundEvent();
        if (target.m_6469_(damagesource, this.damage.floatValue() * this.getDamageMultiplier())) {
            if (target.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                if (owner instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)owner;
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)livingOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)target);
                    this.m_7761_(livingEntity);
                }
            }
        }
        float volume = 1.0f;
        this.m_5496_(soundEvent, volume, 1.0f);
    }
}

