/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.capabilities;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class CapabilityProvider<T extends INBTSerializable<CompoundTag>>
implements ICapabilitySerializable<CompoundTag> {
    private final T instance;
    private final LazyOptional<T> optional;
    private final Capability<T> capability;

    public CapabilityProvider(Capability<T> capability, Supplier<T> instanceSupplier) {
        this.capability = capability;
        this.instance = (INBTSerializable)instanceSupplier.get();
        this.optional = LazyOptional.of(() -> this.instance);
    }

    @NotNull
    public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
        return this.capability.orEmpty(cap, this.optional);
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.instance.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.instance.deserializeNBT((Tag)nbt);
    }
}

