/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.goo.brutality.event.ConsumeManaEvent;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.SealUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;

public class EntityCapabilities {
    private static final String MIRACLE_BLIGHTED = "isMiracleBlighted";
    private static final String SHOULD_ROTATE = "shouldRotate";
    private static final String RAGE_VALUE = "rageValue";
    private static final String MANA_VALUE = "manaValue";
    private static final String IS_RAGE = "isRage";
    private static final String IS_THE_VOID = "isTheVoid";
    private static final String IS_LIGHT_BOUND = "isBound";
    private static final String HIT_COUNT = "hitCount";
    private static final String LAST_HIT_TIME = "lastHitTime";
    private static final String LAST_VICTIM_ID = "lastVictimId";
    private static final String BOOSTER_TYPE = "boosterType";
    private static final String KIT_TYPE = "kitType";
    private static final String SEAL_TYPE = "seal_type";

    @AutoRegisterCapability
    public static class PlayerComboCap
    implements INBTSerializable<CompoundTag> {
        private int lastVictimId;
        private int hitCount;
        private long lastHitTime;

        public void resetAll() {
            this.lastVictimId = -10;
            this.hitCount = 0;
            this.lastHitTime = 0L;
        }

        public int lastVictimId() {
            return this.lastVictimId;
        }

        public void setLastVictimId(int lastVictimId) {
            this.lastVictimId = lastVictimId;
        }

        public int hitCount() {
            return this.hitCount;
        }

        public void setHitCount(int hitCount) {
            this.hitCount = hitCount;
        }

        public long lastHitTime() {
            return this.lastHitTime;
        }

        public void setLastHitTime(long lastHitTime) {
            this.lastHitTime = lastHitTime;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("LastVictim", this.lastVictimId);
            tag.m_128405_("HitCount", this.hitCount);
            tag.m_128356_("LastHitTime", this.lastHitTime);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setHitCount(nbt.m_128451_(EntityCapabilities.HIT_COUNT));
            this.setLastHitTime(nbt.m_128454_(EntityCapabilities.LAST_HIT_TIME));
            this.setLastVictimId(nbt.m_128451_(EntityCapabilities.LAST_VICTIM_ID));
        }
    }

    @AutoRegisterCapability
    public static class PlayerManaCap
    implements INBTSerializable<CompoundTag> {
        private float manaValue = 0.0f;

        public float manaValue() {
            return this.manaValue;
        }

        public boolean isMaxMana(Player player) {
            AttributeInstance maxMana = player.m_21051_((Attribute)ModAttributes.MAX_MANA.get());
            if (maxMana != null) {
                return (double)this.manaValue == maxMana.m_22135_();
            }
            return false;
        }

        public void setManaValue(float manaValue) {
            this.manaValue = manaValue;
        }

        public void incrementMana(float amount) {
            this.manaValue = this.manaValue() + amount;
        }

        public void decrementMana(float amount) {
            this.manaValue = this.manaValue() - amount;
        }

        public float getCurrentManaRatio(Player player) {
            AttributeInstance maxMana = player.m_21051_((Attribute)ModAttributes.MAX_MANA.get());
            if (maxMana != null) {
                return (float)((double)this.manaValue / maxMana.m_22135_());
            }
            return 0.0f;
        }

        public void decrementMana(Player player, IBrutalitySpell spell, int spellLevel, float amount) {
            this.decrementMana(amount);
            MinecraftForge.EVENT_BUS.post((Event)new ConsumeManaEvent(player, spell, spellLevel, amount));
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_(EntityCapabilities.MANA_VALUE, this.manaValue());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setManaValue(nbt.m_128451_(EntityCapabilities.MANA_VALUE));
        }
    }

    @AutoRegisterCapability
    public static class PlayerRageCap
    implements INBTSerializable<CompoundTag> {
        private float rageValue = 0.0f;

        public float rageValue() {
            return this.rageValue;
        }

        public void setRageValue(float rageValue) {
            this.rageValue = rageValue;
        }

        public void incrementRage(float amount) {
            this.rageValue = this.rageValue() + amount;
        }

        public void decrementRage(float amount) {
            this.rageValue = this.rageValue() - amount;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_(EntityCapabilities.RAGE_VALUE, this.rageValue());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setRageValue(nbt.m_128451_(EntityCapabilities.RAGE_VALUE));
        }
    }

    @AutoRegisterCapability
    public static class EntityStarCountCap
    implements INBTSerializable<CompoundTag> {
        private final Map<UUID, Map<Integer, Integer>> playerStarCounts = new HashMap<UUID, Map<Integer, Integer>>();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.playerStarCounts.forEach((playerUuid, entityMap) -> {
                CompoundTag entityTag = new CompoundTag();
                entityMap.forEach((entityUuid, count) -> entityTag.m_128405_(entityUuid.toString(), count.intValue()));
                tag.m_128365_(playerUuid.toString(), (Tag)entityTag);
            });
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerStarCounts.clear();
            for (String playerKey : nbt.m_128431_()) {
                try {
                    UUID playerUuid = UUID.fromString(playerKey);
                    CompoundTag entityTag = nbt.m_128469_(playerKey);
                    HashMap<Integer, Integer> entityMap = new HashMap<Integer, Integer>();
                    for (String entityKey : entityTag.m_128431_()) {
                        try {
                            Integer entityId = Integer.parseInt(entityKey);
                            entityMap.put(entityId, entityTag.m_128451_(entityKey));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    this.playerStarCounts.put(playerUuid, entityMap);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        public Map<UUID, Map<Integer, Integer>> getAllStarCounts() {
            return this.playerStarCounts;
        }

        public int getStarCount(UUID playerId, Integer entityId) {
            return ((Map)this.playerStarCounts.getOrDefault(playerId, new HashMap())).getOrDefault(entityId, 0);
        }

        public void incrementStarCount(UUID playerId, Integer entityId) {
            this.setStarCount(playerId, entityId, this.getStarCount(playerId, entityId) + 1);
        }

        public void setStarCount(UUID playerId, Integer entityId, int count) {
            this.playerStarCounts.computeIfAbsent(playerId, k -> new HashMap()).put(entityId, count);
            if (count == 0) {
                this.playerStarCounts.get(playerId).remove(entityId);
                if (this.playerStarCounts.get(playerId).isEmpty()) {
                    this.playerStarCounts.remove(playerId);
                }
            }
        }

        public void clearStarCount(UUID playerId, Integer entityId) {
            this.setStarCount(playerId, entityId, 0);
        }

        public Map<Integer, Integer> getEntitiesForPlayer(UUID playerId) {
            return this.playerStarCounts.getOrDefault(playerId, new HashMap());
        }
    }

    @AutoRegisterCapability
    public static class EntityStickyBombCap
    implements INBTSerializable<CompoundTag> {
        private final Map<UUID, Map<Integer, Integer>> playerStickyBombCounts = new HashMap<UUID, Map<Integer, Integer>>();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.playerStickyBombCounts.forEach((playerUuid, entityMap) -> {
                CompoundTag entityTag = new CompoundTag();
                entityMap.forEach((entityUuid, count) -> entityTag.m_128405_(entityUuid.toString(), count.intValue()));
                tag.m_128365_(playerUuid.toString(), (Tag)entityTag);
            });
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerStickyBombCounts.clear();
            for (String playerKey : nbt.m_128431_()) {
                try {
                    UUID playerUuid = UUID.fromString(playerKey);
                    CompoundTag entityTag = nbt.m_128469_(playerKey);
                    HashMap<Integer, Integer> entityMap = new HashMap<Integer, Integer>();
                    for (String entityKey : entityTag.m_128431_()) {
                        try {
                            Integer entityId = Integer.parseInt(entityKey);
                            entityMap.put(entityId, entityTag.m_128451_(entityKey));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    this.playerStickyBombCounts.put(playerUuid, entityMap);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }

        public Map<UUID, Map<Integer, Integer>> getAllStickyBombCounts() {
            return this.playerStickyBombCounts;
        }

        public int getStickyBombCount(UUID playerId, Integer entityId) {
            return ((Map)this.playerStickyBombCounts.getOrDefault(playerId, new HashMap())).getOrDefault(entityId, 0);
        }

        public void incrementStickyBombCount(UUID playerId, Integer entityId) {
            this.setStickyBombCount(playerId, entityId, this.getStickyBombCount(playerId, entityId) + 1);
        }

        public void setStickyBombCount(UUID playerId, Integer entityId, int count) {
            this.playerStickyBombCounts.computeIfAbsent(playerId, k -> new HashMap()).put(entityId, count);
            if (count == 0) {
                this.playerStickyBombCounts.get(playerId).remove(entityId);
                if (this.playerStickyBombCounts.get(playerId).isEmpty()) {
                    this.playerStickyBombCounts.remove(playerId);
                }
            }
        }

        public void clearStickyBombCount(UUID playerId, Integer entityId) {
            this.setStickyBombCount(playerId, entityId, 0);
        }

        public Map<Integer, Integer> getEntitiesForPlayer(UUID playerId) {
            return this.playerStickyBombCounts.getOrDefault(playerId, new HashMap());
        }
    }

    @AutoRegisterCapability
    public static class EntitySealTypeCap
    implements INBTSerializable<CompoundTag> {
        private SealUtils.SEAL_TYPE sealType = SealUtils.SEAL_TYPE.NONE;

        public SealUtils.SEAL_TYPE getSealType() {
            return this.sealType;
        }

        public void setSealType(SealUtils.SEAL_TYPE sealType) {
            this.sealType = sealType;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(EntityCapabilities.BOOSTER_TYPE, this.sealType.name());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            String name = nbt.m_128461_(EntityCapabilities.SEAL_TYPE);
            try {
                this.setSealType(SealUtils.SEAL_TYPE.valueOf(name));
            }
            catch (IllegalArgumentException e) {
                this.setSealType(SealUtils.SEAL_TYPE.NONE);
            }
        }
    }

    @AutoRegisterCapability
    public static class RespawnCap
    implements INBTSerializable<CompoundTag> {
        private BOOSTER_TYPE boosterType = BOOSTER_TYPE.NONE;
        private KIT_TYPE kitType = KIT_TYPE.NONE;

        public BOOSTER_TYPE getBoosterType() {
            return this.boosterType;
        }

        public void setBoosterType(BOOSTER_TYPE boosterType) {
            this.boosterType = boosterType;
        }

        public KIT_TYPE getKitType() {
            return this.kitType;
        }

        public void setKitType(KIT_TYPE kitType) {
            this.kitType = kitType;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(EntityCapabilities.BOOSTER_TYPE, this.boosterType.name());
            tag.m_128359_(EntityCapabilities.KIT_TYPE, this.kitType.name());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            String name = nbt.m_128461_(EntityCapabilities.BOOSTER_TYPE);
            try {
                this.setBoosterType(BOOSTER_TYPE.valueOf(name));
                this.setKitType(KIT_TYPE.valueOf(name));
            }
            catch (IllegalArgumentException e) {
                this.setBoosterType(BOOSTER_TYPE.NONE);
                this.setKitType(KIT_TYPE.NONE);
            }
        }

        public static enum BOOSTER_TYPE {
            NONE,
            SILVER,
            DIAMOND,
            EVIL_KING;

        }

        public static enum KIT_TYPE {
            NONE,
            SILVER,
            DIAMOND,
            EVIL_KING;

        }
    }

    @AutoRegisterCapability
    public static class EntityShouldRotateCap
    implements INBTSerializable<CompoundTag> {
        private boolean shouldRotate = false;

        public boolean isShouldRotate() {
            return this.shouldRotate;
        }

        public void setShouldRotate(boolean active) {
            this.shouldRotate = active;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_(EntityCapabilities.SHOULD_ROTATE, this.isShouldRotate());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setShouldRotate(nbt.m_128471_(EntityCapabilities.SHOULD_ROTATE));
        }
    }

    @AutoRegisterCapability
    public static class EntityEffectCap
    implements INBTSerializable<CompoundTag> {
        private boolean miracleBlighted = false;
        private boolean isRage = false;
        private boolean isTheVoid = false;
        private boolean isLightBound = false;

        public boolean isMiracleBlighted() {
            return this.miracleBlighted;
        }

        public boolean isRage() {
            return this.isRage;
        }

        public boolean isTheVoid() {
            return this.isTheVoid;
        }

        public boolean isLightBound() {
            return this.isLightBound;
        }

        public void setLightBound(boolean lightBound) {
            this.isLightBound = lightBound;
        }

        public void setMiracleBlighted(boolean active) {
            this.miracleBlighted = active;
        }

        public void setRage(boolean active) {
            this.isRage = active;
        }

        public void setTheVoid(boolean active) {
            this.isTheVoid = active;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_(EntityCapabilities.MIRACLE_BLIGHTED, this.isMiracleBlighted());
            tag.m_128379_(EntityCapabilities.IS_RAGE, this.isRage());
            tag.m_128379_(EntityCapabilities.IS_THE_VOID, this.isTheVoid());
            tag.m_128379_(EntityCapabilities.IS_LIGHT_BOUND, this.isLightBound());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setMiracleBlighted(nbt.m_128471_(EntityCapabilities.MIRACLE_BLIGHTED));
            this.setRage(nbt.m_128471_(EntityCapabilities.IS_RAGE));
            this.setTheVoid(nbt.m_128471_(EntityCapabilities.IS_THE_VOID));
            this.setLightBound(nbt.m_128471_(EntityCapabilities.IS_LIGHT_BOUND));
        }
    }
}

