/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.generic;

import java.util.Locale;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FateCard
extends BrutalityAbstractThrowingProjectile
implements BrutalityGeoEntity {
    private static final EntityDataAccessor<Integer> CARD_TYPE_INDEX = SynchedEntityData.m_135353_(FateCard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this, (boolean)true);

    public FateCard(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
        this.setCardType(Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)(CARD_TYPE.values().length - 1)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CARD_TYPE_INDEX, (Object)0);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("cardType", this.getCardIndex());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("cardType")) {
            this.setCardType(pCompound.m_128451_("cardType"));
        }
    }

    public CARD_TYPE getCardType() {
        return CARD_TYPE.values()[(Integer)this.f_19804_.m_135370_(CARD_TYPE_INDEX)];
    }

    @Override
    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_12571_;
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_12571_;
    }

    public int getCardIndex() {
        return (Integer)this.f_19804_.m_135370_(CARD_TYPE_INDEX);
    }

    public void setCardType(int index) {
        this.f_19804_.m_135381_(CARD_TYPE_INDEX, (Object)index);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 100) {
            this.m_146870_();
        }
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public String texture() {
        return "fate_card_" + this.getCardType().name().toLowerCase(Locale.ROOT);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)entity;
            switch (this.getCardType()) {
                case SLOW: {
                    livingHit.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
                    break;
                }
                case STUN: {
                    livingHit.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.STUNNED.get(), 5, 0));
                    break;
                }
                case IGNITE: {
                    livingHit.m_20254_(5);
                    break;
                }
                case POISON: {
                    livingHit.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 1));
                    break;
                }
                case WITHER: {
                    livingHit.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1));
                    break;
                }
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public static enum CARD_TYPE {
        SLOW,
        STUN,
        IGNITE,
        POISON,
        WITHER;

    }
}

