/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.generic;

import com.lowdragmc.photon.client.fx.EntityEffect;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.util.ModResources;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VampireHealProjectile
extends ThrowableProjectile
implements BrutalityGeoEntity {
    private static final EntityDataAccessor<Integer> HOMING_TARGET_ID = SynchedEntityData.m_135353_(VampireHealProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this, (boolean)true);

    public VampireHealProjectile(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HOMING_TARGET_ID, (Object)-1);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_20242_(boolean pNoGravity) {
        super.m_20242_(true);
    }

    public void m_8119_() {
        if (this.f_19803_ && !(this.m_9236_() instanceof ServerLevel)) {
            EntityEffect vampireTrail = new EntityEffect(ModResources.VAMPIRE_TRIAL_FX, this.m_9236_(), (Entity)this, EntityEffect.AutoRotate.NONE);
            vampireTrail.start();
        }
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            Vec3 targetVec = owner.m_20318_(1.0f).m_82520_(0.0, (double)(owner.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20318_(1.0f));
            double distance = targetVec.m_82553_();
            if (distance > 0.01) {
                double scale = 1.0 / (distance * 2.0 + 0.1) + 0.25;
                Vec3 motion = targetVec.m_82541_().m_82490_(scale);
                this.m_246865_(motion);
                if (this.m_20184_().m_82553_() > 1.0) {
                    this.m_20256_(this.m_20184_().m_82490_(0.85));
                }
            }
            if ((double)owner.m_20270_((Entity)this) < 0.25 && !this.m_9236_().m_5776_()) {
                owner.m_5634_((float)owner.m_21133_(Attributes.f_22281_) * 0.075f);
                this.m_146870_();
            }
        }
    }

    public void m_142036_() {
        EntityEffect vampireTrail = new EntityEffect(ModResources.VAMPIRE_TRIAL_FX, this.m_9236_(), (Entity)this, EntityEffect.AutoRotate.NONE);
        if (vampireTrail.getRuntime() != null) {
            vampireTrail.getRuntime().destroy(false);
            EntityEffect.CACHE.computeIfPresent(this, (entity, effects) -> {
                effects.remove(vampireTrail);
                return effects.isEmpty() ? null : effects;
            });
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        entity.f_19802_ = 0;
        Entity owner = this.m_19749_();
        if (owner != null && entity != owner) {
            entity.m_6469_(entity.m_269291_().m_269104_(owner, (Entity)this), 5.0f);
        }
        this.m_146870_();
        super.m_5790_(pResult);
    }
}

