/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.ray;

import java.util.UUID;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.registry.BrutalityModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExplosionRay
extends Entity
implements BrutalityGeoEntity {
    private int lifespan = 160;
    private int yaw;
    private int pitch;
    private int circleCount;
    private static final EntityDataAccessor<Integer> DATA_YAW = SynchedEntityData.m_135353_(ExplosionRay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_PITCH = SynchedEntityData.m_135353_(ExplosionRay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_CIRCLE_COUNT = SynchedEntityData.m_135353_(ExplosionRay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this, (boolean)true);
    private boolean soundPlayed = false;

    public ExplosionRay(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_YAW, (Object)0);
        this.f_19804_.m_135372_(DATA_PITCH, (Object)0);
        this.f_19804_.m_135372_(DATA_CIRCLE_COUNT, (Object)0);
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
        this.setSyncedYaw(yaw);
    }

    public void setPitch(int pitch) {
        this.pitch = pitch;
        this.setSyncedPitch(pitch);
    }

    public void setCircleCount(int count) {
        this.circleCount = count;
        this.setSyncedPitch(count);
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    private void setSyncedYaw(int yaw) {
        this.f_19804_.m_135381_(DATA_YAW, (Object)yaw);
    }

    private void setSyncedPitch(int pitch) {
        this.f_19804_.m_135381_(DATA_PITCH, (Object)pitch);
    }

    private void setSyncedCircleCount(int count) {
        this.f_19804_.m_135381_(DATA_CIRCLE_COUNT, (Object)count);
    }

    public int getSyncedYaw() {
        return (Integer)this.f_19804_.m_135370_(DATA_YAW);
    }

    public int getSyncedPitch() {
        return (Integer)this.f_19804_.m_135370_(DATA_PITCH);
    }

    public int getSyncedCircleCount() {
        return (Integer)this.f_19804_.m_135370_(DATA_CIRCLE_COUNT);
    }

    protected void m_7378_(CompoundTag tag) {
        this.yaw = tag.m_128451_("Yaw");
        this.pitch = tag.m_128451_("Pitch");
        this.circleCount = tag.m_128451_("CircleCount");
        this.setSyncedYaw(this.yaw);
        this.setSyncedPitch(this.pitch);
        this.setSyncedCircleCount(this.circleCount);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("Yaw", this.yaw);
        tag.m_128405_("Pitch", this.pitch);
        tag.m_128405_("CircleCount", this.circleCount);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setOwner(UUID ownerUUID) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.yaw != this.getSyncedYaw()) {
                this.setSyncedYaw(this.yaw);
            }
            if (this.pitch != this.getSyncedPitch()) {
                this.setSyncedPitch(this.pitch);
            }
            if (this.circleCount != this.getSyncedCircleCount()) {
                this.setSyncedCircleCount(this.circleCount);
            }
        } else if (!this.soundPlayed && this.f_19797_ > 2) {
            int syncedCount = this.getSyncedCircleCount();
            float volume = syncedCount * 3 + 2;
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BrutalityModSounds.BIGGER_EXPLOSION.get(), SoundSource.BLOCKS, volume, 1.0f, false);
            this.soundPlayed = true;
        }
        if (this.f_19797_ >= this.lifespan) {
            this.m_146870_();
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenPlay("spawn")))});
    }
}

