/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident;

import com.lowdragmc.photon.client.fx.EntityEffect;
import javax.annotation.Nullable;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractTrident;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.util.ModResources;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class ExobladeBeam
extends BrutalityAbstractTrident
implements BrutalityGeoEntity {
    private static final EntityDataAccessor<Integer> HOMING_TARGET_ID = SynchedEntityData.m_135353_(ExobladeBeam.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public ExobladeBeam(EntityType<? extends BrutalityAbstractTrident> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19804_.m_135381_(HOMING_TARGET_ID, (Object)-1);
        this.collideWithBlocks = false;
    }

    public ExobladeBeam(Level pLevel, LivingEntity pShooter, ItemStack pStack, EntityType<? extends AbstractArrow> trident) {
        super(pLevel, pShooter, pStack, trident);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOMING_TARGET_ID, (Object)-1);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("HomingTargetId", ((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID)).intValue());
    }

    @Override
    public float getGravity() {
        return 0.0f;
    }

    public float getDamage(@Nullable LivingEntity livingEntity) {
        return 12.0f;
    }

    @Override
    public int getInGroundLifespan() {
        return 60;
    }

    @Override
    public void m_8119_() {
        if (this.f_19803_ && !(this.m_9236_() instanceof ServerLevel)) {
            EntityEffect rainbowTrail = new EntityEffect(ModResources.RAINBOW_TRAIL_FX, this.m_9236_(), (Entity)this, EntityEffect.AutoRotate.NONE);
            rainbowTrail.start();
        }
        super.m_8119_();
        this.m_6901_();
        if (!this.f_36703_ && !this.dealtDamage) {
            if ((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID) == -1) {
                LivingEntity nearestMob = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148352_().m_148355_().m_26893_().m_26888_(mob -> {
                    if (mob == this.m_19749_()) {
                        return false;
                    }
                    if (mob instanceof Player) {
                        Player player = (Player)mob;
                        return !player.m_7500_() && !player.m_5833_();
                    }
                    return true;
                }), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), new AABB(this.m_20183_()).m_82400_(5.0));
                if (nearestMob != null) {
                    this.f_19804_.m_135381_(HOMING_TARGET_ID, (Object)nearestMob.m_19879_());
                }
            } else {
                Entity target = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID)).intValue());
                if (target != null) {
                    this.collideWithBlocks = false;
                    Vec3 toVec = target.m_20318_(1.0f).m_82546_(this.m_20318_(1.0f));
                    double distance = toVec.m_82553_();
                    if (distance > 0.01) {
                        double scale = 7.5 / (distance * 2.0 + 0.1) + 0.25;
                        Vec3 motion = toVec.m_82541_().m_82490_(scale);
                        this.m_246865_(motion);
                        if (this.m_20184_().m_82553_() > 2.0) {
                            this.m_20256_(this.m_20184_().m_82490_(0.85));
                        }
                    }
                } else {
                    this.collideWithBlocks = true;
                }
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        LivingEntity livingEntity;
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity && (entity = (livingEntity = (LivingEntity)entity).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            if (serverLevel.f_46441_.m_188499_()) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.MIRACLE_BLIGHT.get(), 80, 0, false, false));
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        this.m_146870_();
        super.m_6532_(pResult);
    }

    @Override
    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

