/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.entity.base.BrutalityAbstractTrident;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownGungnir
extends BrutalityAbstractTrident
implements BrutalityGeoEntity {
    private static final EntityDataAccessor<Integer> HOMING_TARGET_ID = SynchedEntityData.m_135353_(ThrownGungnir.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HIT_COUNT = SynchedEntityData.m_135353_(ThrownGungnir.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HOMING_COOLDOWN = SynchedEntityData.m_135353_(ThrownGungnir.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ThrownGungnir(Level pLevel, LivingEntity pShooter, ItemStack pStack, EntityType<? extends AbstractArrow> trident) {
        super(pLevel, pShooter, pStack, trident);
        this.f_19804_.m_135381_(HOMING_TARGET_ID, (Object)-1);
        this.f_19804_.m_135381_(HIT_COUNT, (Object)0);
        this.f_19804_.m_135381_(HOMING_COOLDOWN, (Object)0);
    }

    public ThrownGungnir(EntityType<? extends BrutalityAbstractTrident> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOMING_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(HIT_COUNT, (Object)0);
        this.f_19804_.m_135372_(HOMING_COOLDOWN, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("HomingTargetId", ((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID)).intValue());
        pCompound.m_128405_("HitCount", ((Integer)this.f_19804_.m_135370_(HIT_COUNT)).intValue());
        pCompound.m_128405_("HomingCooldown", ((Integer)this.f_19804_.m_135370_(HOMING_COOLDOWN)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("HomingTargetId", 3)) {
            this.f_19804_.m_135381_(HOMING_TARGET_ID, (Object)pCompound.m_128451_("HomingTargetId"));
        }
        if (pCompound.m_128425_("HitCount", 3)) {
            this.f_19804_.m_135381_(HIT_COUNT, (Object)pCompound.m_128451_("HitCount"));
        }
        if (pCompound.m_128425_("HitCount", 3)) {
            this.f_19804_.m_135381_(HOMING_COOLDOWN, (Object)pCompound.m_128451_("HomingCooldown"));
        }
    }

    @Override
    protected Vec3 getTridentBounceStrength() {
        return new Vec3(-0.01, -1.0, -0.01);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if ((Integer)this.f_19804_.m_135370_(HIT_COUNT) >= this.getHitQuota()) {
            this.dealtDamage = true;
            this.collideWithBlocks = true;
            return;
        }
        int cooldown = (Integer)this.f_19804_.m_135370_(HOMING_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(HOMING_COOLDOWN, (Object)(cooldown - 1));
            return;
        }
        if (!this.f_36703_ && !this.dealtDamage) {
            if ((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID) == -1) {
                LivingEntity nearestMob = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148352_().m_148355_().m_26893_().m_26888_(mob -> {
                    if (mob == this.m_19749_()) {
                        return false;
                    }
                    if (mob instanceof Player) {
                        Player player = (Player)mob;
                        return !player.m_7500_() && !player.m_5833_();
                    }
                    return true;
                }), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), new AABB(this.m_20183_()).m_82400_(25.0));
                if (nearestMob != null) {
                    this.f_19804_.m_135381_(HOMING_TARGET_ID, (Object)nearestMob.m_19879_());
                }
            } else {
                Entity target = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(HOMING_TARGET_ID)).intValue());
                if (target != null) {
                    this.collideWithBlocks = false;
                    Vec3 toVec = target.m_20318_(1.0f).m_82546_(this.m_20318_(1.0f));
                    double distance = toVec.m_82553_();
                    if (distance > 0.01) {
                        double scale = 2.5 / (distance * 2.0 + 0.1) + 0.25;
                        Vec3 motion = toVec.m_82541_().m_82490_(scale);
                        this.m_246865_(motion);
                        if (this.m_20184_().m_82553_() > 2.0) {
                            this.m_20256_(this.m_20184_().m_82490_(0.85));
                        }
                    }
                } else {
                    this.collideWithBlocks = true;
                }
            }
        }
    }

    @Override
    protected int getHitQuota() {
        return (Integer)BrutalityCommonConfig.GUNGNIR_HIT_QUOTA.get();
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        int hitCount = (Integer)this.f_19804_.m_135370_(HIT_COUNT);
        this.f_19804_.m_135381_(HIT_COUNT, (Object)(hitCount + 1));
        this.f_19804_.m_135381_(HOMING_COOLDOWN, (Object)20);
        if (hitCount >= this.getHitQuota()) {
            this.dealtDamage = true;
        }
    }
}

